// Adapted from https://gist.github.com/nicolasdao/2e6cdb8a92b5584d90019a0224b1fddc
const path = require('path');
const webpack = require('webpack');

// Simply configure those variables:
const JS_SOURCE_FILES = ['babel-polyfill', './src/index.js'];
const OUTPUT_FILENAME = 'matlab-ctree-parser';
const DEST_FOLDER = 'dist';
const COPYRIGHT = `Copyright 2020 Renjie Wu <rwu034 AT ucr.edu>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.`;

module.exports = {
	mode: 'production',
	entry: JS_SOURCE_FILES,
	output: {
		path: path.join(__dirname, DEST_FOLDER),
        filename: `${OUTPUT_FILENAME}.min.js`,
		libraryTarget: 'umd',
		umdNamedDefine: true
	},
	module: {
		rules: [{
			// Only run `.js` files through Babel
			test: /\.m?js$/,
			exclude: /(node_modules)/,
			use: {
				loader: 'babel-loader',
				options: {
					presets: ['@babel/preset-env']
				}
			}
		}]
    },
    node: {
        module: 'empty',
        net: 'empty',
        fs: 'empty'
    },
	plugins: [ new webpack.BannerPlugin(COPYRIGHT) ]
};