/*
 * Decompiled with CFR 0.152.
 */
package library.wavelets.lift;

import library.wavelets.lift.Liftbase;

public class Haar
extends Liftbase {
    @Override
    protected void predict(double[] vec, int N, int direction) {
        int half = N >> 1;
        for (int i = 0; i < half; ++i) {
            double predictVal = vec[i];
            int j = i + half;
            if (direction == 1) {
                vec[j] = vec[j] - predictVal;
                continue;
            }
            if (direction == 2) {
                vec[j] = vec[j] + predictVal;
                continue;
            }
            System.out.println("haar::predict: bad direction value");
        }
    }

    @Override
    protected void update(double[] vec, int N, int direction) {
        int half = N >> 1;
        for (int i = 0; i < half; ++i) {
            int j = i + half;
            double updateVal = vec[j] / 2.0;
            if (direction == 1) {
                vec[i] = vec[i] + updateVal;
                continue;
            }
            if (direction == 2) {
                vec[i] = vec[i] - updateVal;
                continue;
            }
            System.out.println("update: bad direction value");
        }
    }
}

