/*
 * Decompiled with CFR 0.152.
 */
package library.wavelets.lift;

public abstract class Liftbase {
    protected final int forward = 1;
    protected final int inverse = 2;

    protected void split(double[] vec, int N) {
        int start = 1;
        for (int end = N - 1; start < end; ++start, --end) {
            for (int i = start; i < end; i += 2) {
                double tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
        }
    }

    protected void merge(double[] vec, int N) {
        int half = N >> 1;
        int start = half - 1;
        int end = half;
        while (start > 0) {
            for (int i = start; i < end; i += 2) {
                double tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
            --start;
            ++end;
        }
    }

    protected abstract void predict(double[] var1, int var2, int var3);

    protected abstract void update(double[] var1, int var2, int var3);

    public void forwardTrans(double[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.predict(vec, n, 1);
            this.update(vec, n, 1);
        }
    }

    public void inverseTrans(double[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.update(vec, n, 2);
            this.predict(vec, n, 2);
            this.merge(vec, n);
        }
    }
}

