/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;

public class GradientFunction
implements MultivariateVectorFunction {
    private final MultivariateDifferentiableFunction f;

    public GradientFunction(MultivariateDifferentiableFunction f) {
        this.f = f;
    }

    public double[] value(double[] point2) {
        DerivativeStructure[] dsX = new DerivativeStructure[point2.length];
        for (int i = 0; i < point2.length; ++i) {
            dsX[i] = new DerivativeStructure(point2.length, 1, i, point2[i]);
        }
        DerivativeStructure dsY = this.f.value(dsX);
        double[] y = new double[point2.length];
        int[] orders = new int[point2.length];
        for (int i = 0; i < point2.length; ++i) {
            orders[i] = 1;
            y[i] = dsY.getPartialDerivative(orders);
            orders[i] = 0;
        }
        return y;
    }
}

