/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.classification.Classifier;
import sfa.classification.TEASERClassifier;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;

@RunWith(value=JUnit4.class)
public class EarlyClassificationTest {
    public static String[] datasets = new String[]{"Coffee", "CBF", "Beef", "ECG200", "FaceFour", "OliveOil", "Gun_Point", "DiatomSizeReduction", "ECGFiveDays", "TwoLeadECG", "SonyAIBORobot SurfaceII", "MoteStrain", "ItalyPowerDemand", "SonyAIBORobot Surface"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUCRClassification() throws IOException {
        try {
            ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
            File dir = new File(classLoader.getResource("datasets/univariate/").getFile());
            TimeSeries.APPLY_Z_NORM = false;
            for (String s : datasets) {
                File d = new File(dir.getAbsolutePath() + "/" + s);
                if (d.exists() && d.isDirectory()) {
                    for (File train : d.listFiles()) {
                        if (!train.getName().toUpperCase().endsWith("TRAIN")) continue;
                        File test = new File(train.getAbsolutePath().replaceFirst("TRAIN", "TEST"));
                        if (!test.exists()) {
                            System.err.println("File " + test.getName() + " does not exist");
                            test = null;
                        }
                        Classifier.DEBUG = false;
                        TimeSeries[] testSamples = TimeSeriesLoader.loadDataset(test);
                        TimeSeries[] trainSamples = TimeSeriesLoader.loadDataset(train);
                        TEASERClassifier t = new TEASERClassifier();
                        TEASERClassifier.S = 20.0;
                        Classifier.Score scoreT = t.eval(trainSamples, testSamples);
                        System.out.println(s + ";" + scoreT.toString());
                    }
                    continue;
                }
                System.out.println("Dataset could not be found: " + d.getAbsolutePath() + ". Please download datasets from [http://www.cs.ucr.edu/~eamonn/time_series_data/].");
            }
        }
        finally {
            TimeSeries.APPLY_Z_NORM = true;
        }
    }
}

