/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.classification.Classifier;
import sfa.classification.MUSEClassifier;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;

@RunWith(value=JUnit4.class)
public class NewMTSArchiveClassificationTest {
    public static String[] datasets = new String[]{"ArticularyWordRecognition", "AtrialFibrillation", "BasicMotions", "CharacterTrajectories", "Cricket", "ERing", "Epilepsy", "EthanolConcentration", "FingerMovements", "HandMovementDirection", "Handwriting", "Heartbeat", "JapaneseVowels", "LSST", "Libras", "NATOPS", "PenDigits", "PhonemeSpectra", "RacketSports", "SelfRegulationSCP1", "SelfRegulationSCP2", "SpokenArabicDigits", "StandWalkJump", "UWaveGestureLibrary"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiVariatelassification() throws IOException {
        try {
            ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
            File dir = new File(classLoader.getResource("datasets/Multivariate_arff/").getFile());
            TimeSeries.APPLY_Z_NORM = false;
            for (String s : datasets) {
                File d = new File(dir.getAbsolutePath() + "/" + s);
                if (d.exists() && d.isDirectory()) {
                    File train = new File(dir.getAbsolutePath() + "/" + s + "/" + s + "_TRAIN.arff");
                    File test = new File(dir.getAbsolutePath() + "/" + s + "/" + s + "_TEST.arff");
                    if (!test.exists()) {
                        System.err.println("File " + test.getName() + " does not exist");
                        test = null;
                    }
                    Classifier.DEBUG = false;
                    boolean useDerivatives = true;
                    TreeMap<String, Double> classMapping = new TreeMap<String, Double>();
                    MultiVariateTimeSeries[] trainSamples = TimeSeriesLoader.loadMultivariateDatsetArff(train, s, classMapping, useDerivatives);
                    MultiVariateTimeSeries[] testSamples = TimeSeriesLoader.loadMultivariateDatsetArff(test, s, classMapping, useDerivatives);
                    MUSEClassifier muse = new MUSEClassifier();
                    Classifier.Score museScore = muse.eval(trainSamples, testSamples);
                    System.out.println(s + ";" + museScore.toString());
                    continue;
                }
                System.out.println("Dataset could not be found: " + d.getAbsolutePath() + ".");
            }
        }
        finally {
            TimeSeries.APPLY_Z_NORM = true;
        }
    }
}

