/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.SFA;
import sfa.transformation.SFADistance;

@RunWith(value=JUnit4.class)
public class SFAMinDistanceTest {
    @Test
    public void testSFAMinDistance() throws IOException {
        int symbols = 8;
        int wordLength = 16;
        boolean normMean = true;
        SFA sfa = new SFA(SFA.HistogramType.EQUI_DEPTH);
        SFADistance sfaDistance = new SFADistance(sfa);
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] train = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TRAIN").getFile());
        TimeSeries[] test = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TEST").getFile());
        short[][] wordsTrain = sfa.fitTransform(train, wordLength, symbols, true);
        double minDistance = Double.MAX_VALUE;
        double accuracy = 0.0;
        int best = 0;
        for (int q = 0; q < test.length; ++q) {
            TimeSeries query = test[q];
            double[] dftQuery = sfa.transformation.transform(query, wordLength);
            short[] wordQuery = sfa.quantization(dftQuery);
            for (int t = 0; t < train.length; ++t) {
                double distance = sfaDistance.getDistance(wordsTrain[t], wordQuery, dftQuery, true, minDistance);
                if (!(distance < minDistance)) continue;
                double realDistance = SFAMinDistanceTest.getEuclideanDistance(train[t], query, minDistance);
                if (realDistance < minDistance) {
                    minDistance = realDistance;
                    best = t;
                }
                Assert.assertTrue("Lower bounding violated:\tSFA: " + distance + "\tED: " + realDistance, realDistance > distance);
            }
            if (!test[q].getLabel().equals(train[best].getLabel())) continue;
            accuracy += 1.0;
        }
        System.out.println("Accuracy: " + String.format("%.3f", accuracy / (double)test.length));
    }

    private static double getEuclideanDistance(TimeSeries t1, TimeSeries t2, double minValue) {
        double distance = 0.0;
        double[] t1Values = t1.getData();
        double[] t2Values = t2.getData();
        for (int i = 0; i < Math.min(t1.getLength(), t2.getLength()); ++i) {
            double value = t1Values[i] - t2Values[i];
            if (!((distance += value * value) > minValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance;
    }
}

