/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.SFA;
import sfa.transformation.SFASupervised;

@RunWith(value=JUnit4.class)
public class SFASupervisedReproducibleIntervals {
    @Test
    public void testSFAWordsWindowing() {
        int symbols = 4;
        int wordLength = 4;
        boolean normMean = true;
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] train = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/BEEF/BEEF_TRAIN").getFile());
        for (int w = 4; w < 120; ++w) {
            double[][] bins = null;
            int[] bestValues = null;
            ArrayList[] orderLine = null;
            for (int i = 0; i < 3; ++i) {
                SFASupervised sfa = new SFASupervised(SFA.HistogramType.INFORMATION_GAIN);
                sfa.fitWindowing(train, w, wordLength, symbols, normMean, false);
                if (bins != null) {
                    try {
                        Assert.assertArrayEquals(bins, (Object[])sfa.bins);
                    }
                    catch (ArrayComparisonFailure ex) {
                        System.out.println(Arrays.toString(sfa.bestValues));
                        System.out.println(Arrays.toString(bestValues));
                        System.out.println(w);
                        sfa.printBins();
                        sfa.bins = bins;
                        sfa.printBins();
                        throw ex;
                    }
                }
                bestValues = sfa.bestValues;
                bins = sfa.bins;
                orderLine = sfa.orderLine;
            }
        }
        System.out.println("Test passed");
    }

    public static String toSfaWord(short[] word, int symbols) {
        StringBuilder sfaWord = new StringBuilder();
        for (short c : word) {
            sfaWord.append((char)(Character.valueOf('a').charValue() + c));
            Assert.assertTrue("Wrong symbols used ", c < symbols && c >= 0);
        }
        return sfaWord.toString();
    }
}

