/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.SFA;

@RunWith(value=JUnit4.class)
public class SFAWordsTest {
    @Test
    public void testSFAWords() throws IOException {
        int symbols = 8;
        int wordLength = 16;
        boolean normMean = true;
        SFA sfa = new SFA(SFA.HistogramType.EQUI_DEPTH);
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] train = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TRAIN").getFile());
        TimeSeries[] test = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TEST").getFile());
        sfa.fitTransform(train, wordLength, symbols, normMean);
        Assert.assertTrue("Wrong word queryLength of SFA transformation detected", sfa.bins.length == wordLength);
        for (int i = 0; i < sfa.bins.length; ++i) {
            for (int j = 0; j < sfa.bins[i].length - 1; ++j) {
                Assert.assertTrue("SFA bins should be monotonically increasing.", sfa.bins[i][j] <= sfa.bins[i][j + 1]);
            }
        }
        for (int q = 0; q < test.length; ++q) {
            short[] wordQuery = sfa.transform(test[q]);
            Assert.assertTrue("SFA word queryLength does not match actual queryLength.", wordQuery.length == wordLength);
        }
    }

    public static String toSfaWord(short[] word, int symbols) {
        StringBuilder sfaWord = new StringBuilder();
        for (short c : word) {
            sfaWord.append((char)(Character.valueOf('a').charValue() + c));
            Assert.assertTrue("Wrong symbols used ", c < symbols && c >= 0);
        }
        sfaWord.append("\t... OK");
        return sfaWord.toString();
    }
}

