/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.SFA;

@RunWith(value=JUnit4.class)
public class SFAWordsVariableLengthTest {
    @Test
    public void testSFAWordsVarLength() throws IOException {
        int symbols = 8;
        int wordLength = 16;
        boolean normMean = true;
        SFA sfa = new SFA(SFA.HistogramType.EQUI_DEPTH);
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] train = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TRAIN").getFile());
        TimeSeries[] test = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TEST").getFile());
        sfa.fitTransform(train, wordLength, symbols, normMean);
        for (int q = 0; q < test.length; ++q) {
            short[] wordQuery = sfa.transform(test[q]);
            for (int length = 4; length <= wordLength; length *= 2) {
                System.out.println("Time Series " + q + "\t" + length + "\t" + SFAWordsVariableLengthTest.toSfaWord(Arrays.copyOf(wordQuery, length)));
            }
        }
    }

    public static String toSfaWord(short[] word) {
        StringBuilder sfaWord = new StringBuilder();
        for (short c : word) {
            sfaWord.append((char)(Character.valueOf('a').charValue() + c));
        }
        return sfaWord.toString();
    }
}

