/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.SFA;

@RunWith(value=JUnit4.class)
public class SFAWordsWindowingTest {
    @Test
    public void testSFAWordsWindowing() throws IOException {
        int symbols = 4;
        int wordLength = 4;
        int windowLength = 64;
        boolean normMean = true;
        SFA sfa = new SFA(SFA.HistogramType.EQUI_DEPTH);
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] train = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TRAIN").getFile());
        TimeSeries[] test = TimeSeriesLoader.loadDataset(classLoader.getResource("datasets/univariate/CBF/CBF_TEST").getFile());
        sfa.fitWindowing(train, windowLength, wordLength, symbols, normMean, true);
        for (int q = 0; q < test.length; ++q) {
            short[][] wordsQuery = sfa.transformWindowing(test[q]);
            Assert.assertTrue("SFA word queryLength does not match actual queryLength.", wordsQuery.length == test[q].getLength() - windowLength + 1);
            for (short[] word : wordsQuery) {
                Assert.assertTrue("SFA word queryLength does not match actual queryLength.", word.length == wordLength);
            }
        }
        System.out.println("Test passed");
    }

    public static String toSfaWord(short[] word, int symbols) {
        StringBuilder sfaWord = new StringBuilder();
        for (short c : word) {
            sfaWord.append((char)(Character.valueOf('a').charValue() + c));
            Assert.assertTrue("Wrong symbols used ", c < symbols && c >= 0);
        }
        return sfaWord.toString();
    }
}

