/*
 * Decompiled with CFR 0.152.
 */
package sfa;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.classification.BOSSEnsembleClassifier;
import sfa.classification.BOSSVSClassifier;
import sfa.classification.Classifier;
import sfa.classification.ShotgunClassifier;
import sfa.classification.ShotgunEnsembleClassifier;
import sfa.classification.WEASELClassifier;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;

@RunWith(value=JUnit4.class)
public class UCRClassificationTest {
    public static String[] datasets = new String[]{"Coffee", "Beef", "CBF", "ECG200", "FaceFour", "OliveOil", "Gun_Point", "DiatomSizeReduction", "ECGFiveDays", "TwoLeadECG", "SonyAIBORobotSurfaceII", "MoteStrain", "ItalyPowerDemand", "SonyAIBORobotSurface"};

    @Test
    public void testUCRClassification() throws IOException {
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        File dir = new File(classLoader.getResource("datasets/univariate/").getFile());
        for (String s : datasets) {
            File d = new File(dir.getAbsolutePath() + "/" + s);
            if (d.exists() && d.isDirectory()) {
                for (File train : d.listFiles()) {
                    if (!train.getName().toUpperCase().endsWith("TRAIN")) continue;
                    File test = new File(train.getAbsolutePath().replaceFirst("TRAIN", "TEST"));
                    if (!test.exists()) {
                        System.err.println("File " + test.getName() + " does not exist");
                        test = null;
                    }
                    Classifier.DEBUG = false;
                    TimeSeries[] testSamples = TimeSeriesLoader.loadDataset(test);
                    TimeSeries[] trainSamples = TimeSeriesLoader.loadDataset(train);
                    WEASELClassifier w = new WEASELClassifier();
                    Classifier.Score scoreW = ((Classifier)w).eval(trainSamples, testSamples);
                    System.out.println(s + ";" + scoreW.toString());
                    BOSSEnsembleClassifier boss = new BOSSEnsembleClassifier();
                    Classifier.Score scoreBOSS = ((Classifier)boss).eval(trainSamples, testSamples);
                    System.out.println(s + ";" + scoreBOSS.toString());
                    BOSSVSClassifier bossVS = new BOSSVSClassifier();
                    Classifier.Score scoreBOSSVS = ((Classifier)bossVS).eval(trainSamples, testSamples);
                    System.out.println(s + ";" + scoreBOSSVS.toString());
                    ShotgunEnsembleClassifier shotgunEnsemble = new ShotgunEnsembleClassifier();
                    Classifier.Score scoreShotgunEnsemble = ((Classifier)shotgunEnsemble).eval(trainSamples, testSamples);
                    System.out.println(s + ";" + scoreShotgunEnsemble.toString());
                    ShotgunClassifier shotgun = new ShotgunClassifier();
                    Classifier.Score scoreShotgun = ((Classifier)shotgun).eval(trainSamples, testSamples);
                    System.out.println(s + ";" + scoreShotgun.toString());
                }
                continue;
            }
            System.out.println("Dataset could not be found: " + d.getAbsolutePath() + ". Please download datasets from [http://www.cs.ucr.edu/~eamonn/time_series_data/].");
        }
    }

    public static void main(String[] args) throws IOException {
        UCRClassificationTest ucr = new UCRClassificationTest();
        ucr.testUCRClassification();
    }
}

