/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.classification.Classifier;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;

@RunWith(value=JUnit4.class)
public abstract class AbstractClassifierTest {
    private static final double DELTA = 0.05;
    protected static final File DATASETS_DIRECTORY = new File(AbstractClassifierTest.class.getClassLoader().getResource("datasets/univariate/").getFile());

    @Test
    public void testClassificationOnUCRData() {
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        for (DataSet dataSet : this.getDataSets()) {
            Classifier classifier = this.trainClassifier(dataSet);
            TestCase.assertNotNull(classifier);
        }
    }

    @Test
    public void testSave() throws IOException {
        DataSet dataSet = this.getDataSets().get(0);
        this.testSaveLoadGivesEqualTestResults(dataSet);
    }

    private void testSaveLoadGivesEqualTestResults(DataSet dataSet) throws IOException {
        Classifier classifier = this.trainClassifier(dataSet);
        File file = this.createTempClassifierFile();
        classifier.save(file);
        Object loadedClassifier = Classifier.load(file);
        Assert.assertNotNull(loadedClassifier);
        this.checkEqualResultsOfClassifiers(dataSet, classifier, (Classifier)loadedClassifier);
    }

    private void checkEqualResultsOfClassifiers(DataSet dataSet, Classifier classifier, Classifier loadedClassifier) {
        TimeSeries[] samples = TimeSeriesLoader.loadDataset(this.getFirstTrainFile(dataSet));
        Classifier.Predictions loadedScore = loadedClassifier.score(samples);
        Classifier.Predictions score = classifier.score(samples);
        Assert.assertArrayEquals(loadedScore.labels, score.labels);
        Assert.assertEquals(loadedScore.correct.get(), score.correct.get());
    }

    private File getFirstTrainFile(DataSet dataset) {
        return this.getTrainFiles(dataset)[0];
    }

    private File createTempClassifierFile() throws IOException {
        File tmpFile = File.createTempFile("classifier", "class");
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    protected Classifier trainClassifier(DataSet dataSet) {
        File[] trainFiles = this.getTrainFiles(dataSet);
        Classifier classifier = null;
        for (File train : trainFiles) {
            File test = new File(train.getAbsolutePath().replaceFirst("TRAIN", "TEST"));
            if (!test.exists()) {
                System.err.println("File " + test.getName() + " does not exist");
                test = null;
            }
            Classifier.DEBUG = false;
            TimeSeries[] testSamples = TimeSeriesLoader.loadDataset(test);
            TimeSeries[] trainSamples = TimeSeriesLoader.loadDataset(train);
            classifier = this.initClassifier();
            Classifier.Score scoreW = classifier.eval(trainSamples, testSamples);
            System.out.println(scoreW.toString());
            TestCase.assertEquals("testing result of " + dataSet.name + " does NOT match", dataSet.testingAccuracy, scoreW.getTestingAccuracy(), 0.05);
            TestCase.assertEquals("training result of " + dataSet.name + " does NOT match", dataSet.trainingAccuracy, scoreW.getTrainingAccuracy(), 0.05);
            if (scoreW.getTestEarliness() == null) continue;
            TestCase.assertEquals("test earliness result of " + dataSet.name + " does NOT match", dataSet.testEarliness, scoreW.getTestEarliness(), 0.05);
        }
        return classifier;
    }

    protected File[] getTrainFiles(DataSet dataSet) {
        File dataSetDirectory = new File(DATASETS_DIRECTORY.getAbsolutePath() + "/" + dataSet.name);
        return this.getTrainFilesFromDir(dataSetDirectory);
    }

    private File[] getTrainFilesFromDir(File dataSetDirectory) {
        return dataSetDirectory.listFiles(pathname -> pathname.getName().toUpperCase().endsWith("TRAIN"));
    }

    protected abstract List<DataSet> getDataSets();

    protected abstract Classifier initClassifier();

    protected static final class DataSet {
        String name;
        double trainingAccuracy;
        double testingAccuracy;
        double testEarliness;

        public DataSet(String name, double trainingAccuracy, double testingAccuracy) {
            this.name = name;
            this.trainingAccuracy = trainingAccuracy;
            this.testingAccuracy = testingAccuracy;
        }

        public DataSet(String name, double trainingAccuracy, double testingAccuracy, double testEarliness) {
            this(name, trainingAccuracy, testingAccuracy);
            this.testEarliness = testEarliness;
        }
    }
}

