/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.Ensemble;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;
import sfa.transformation.BOSS;

public class BOSSEnsembleClassifier
extends Classifier {
    public static double factor = 0.92;
    public static int maxF = 16;
    public static int minF = 6;
    public static int maxS = 4;
    public static int MAX_WINDOW_LENGTH = 250;
    public Ensemble<BOSSModel> model;

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            BOSSEnsembleClassifier.outputResult(score.training, startTime, testSamples.length);
            System.out.println("");
        }
        int correctTesting = this.score((TimeSeries[])testSamples).correct.get();
        return new Classifier.Score("BOSS Ensemble", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        this.generateIndices(trainSamples);
        Classifier.Score bestScore = null;
        int bestCorrectTraining = 0;
        int minWindowLength = 10;
        int maxWindowLength = this.getMax(trainSamples, MAX_WINDOW_LENGTH);
        Integer[] windows = this.getWindowsBetween(minWindowLength, maxWindowLength);
        for (boolean normMean : NORMALIZATION) {
            Ensemble<BOSSModel> model = this.fitEnsemble(windows, normMean, trainSamples);
            Double[] labels = this.predict(model, trainSamples);
            Classifier.Predictions pred = this.evalLabels(trainSamples, labels);
            if (model != null && bestCorrectTraining >= pred.correct.get()) continue;
            bestCorrectTraining = pred.correct.get();
            bestScore = model.getHighestScoringModel().score;
            bestScore.training = pred.correct.get();
            this.model = model;
        }
        return bestScore;
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    @Override
    public Double[] predict(TimeSeries[] testSamples) {
        return this.predict(this.model, testSamples);
    }

    protected Ensemble<BOSSModel> fitEnsemble(final Integer[] windows, final boolean normMean, final TimeSeries[] samples) {
        final ArrayList results = new ArrayList(windows.length);
        final AtomicInteger correctTraining = new AtomicInteger(0);
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < windows.length; ++i) {
                    if (i % Classifier.threads != id) continue;
                    BOSSModel model = new BOSSModel(normMean, windows[i]);
                    try {
                        BOSS boss = new BOSS(maxF, maxS, windows[i], model.normed);
                        int[][] words = boss.createWords(samples);
                        for (int f = minF; f <= maxF; f += 2) {
                            BOSS.BagOfPattern[] bag = boss.createBagOfPattern(words, samples, f);
                            Classifier.Predictions p = BOSSEnsembleClassifier.this.predict(bag, bag);
                            if (p.correct.get() <= model.score.training) continue;
                            model.score.training = p.correct.get();
                            model.features = f;
                            model.boss = boss;
                            model.bag = bag;
                            if (p.correct.get() != samples.length) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AtomicInteger atomicInteger = correctTraining;
                    synchronized (atomicInteger) {
                        if (model.score.training > correctTraining.get()) {
                            correctTraining.set(model.score.training);
                        }
                        if ((double)model.score.training >= (double)correctTraining.get() * factor) {
                            results.add(model);
                        }
                        continue;
                    }
                }
            }
        });
        return this.filterByFactor(results, correctTraining.get(), factor);
    }

    protected Classifier.Predictions predict(final BOSS.BagOfPattern[] bagOfPatternsTestSamples, final BOSS.BagOfPattern[] bagOfPatternsTrainSamples) {
        final Classifier.Predictions p = new Classifier.Predictions(new Double[bagOfPatternsTestSamples.length], 0);
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < bagOfPatternsTestSamples.length; ++i) {
                    if (i % 8 != id) continue;
                    long minDistance = Integer.MAX_VALUE;
                    double noMatchDistance = 0.0;
                    for (IntIntCursor key : bagOfPatternsTestSamples[i].bag) {
                        noMatchDistance += (double)(key.value * key.value);
                    }
                    block2: for (int j = 0; j < bagOfPatternsTrainSamples.length; ++j) {
                        if (bagOfPatternsTestSamples[i] == bagOfPatternsTrainSamples[j]) continue;
                        long distance = 0L;
                        for (IntIntCursor key : bagOfPatternsTestSamples[i].bag) {
                            long buf = key.value - bagOfPatternsTrainSamples[j].bag.get(key.key);
                            if ((distance += buf * buf) < minDistance) continue;
                            continue block2;
                        }
                        if ((double)distance == noMatchDistance || distance >= minDistance) continue;
                        minDistance = distance;
                        p.labels[i] = bagOfPatternsTrainSamples[j].label;
                    }
                    if (!BOSSEnsembleClassifier.this.compareLabels(bagOfPatternsTestSamples[i].label, p.labels[i])) continue;
                    p.correct.incrementAndGet();
                }
            }
        });
        return p;
    }

    protected Double[] predict(final Ensemble<BOSSModel> model, final TimeSeries[] testSamples) {
        final List[] testLabels = new List[testSamples.length];
        for (int i = 0; i < testLabels.length; ++i) {
            testLabels[i] = new ArrayList();
        }
        final List<Integer> usedLengths = Collections.synchronizedList(new ArrayList(model.size()));
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < model.size(); ++i) {
                    if (i % Classifier.threads != id) continue;
                    BOSSModel score = (BOSSModel)model.get(i);
                    usedLengths.add(score.windowLength);
                    BOSS model2 = score.boss;
                    int[][] wordsTest = model2.createWords(testSamples);
                    BOSS.BagOfPattern[] bagTest = model2.createBagOfPattern(wordsTest, testSamples, score.features);
                    Classifier.Predictions p = BOSSEnsembleClassifier.this.predict(bagTest, score.bag);
                    for (int j = 0; j < p.labels.length; ++j) {
                        List list = testLabels[j];
                        synchronized (list) {
                            if (p.labels[j] != null) {
                                testLabels[j].add(new Classifier.Pair<Double, Integer>(p.labels[j], score.score.training));
                            }
                            continue;
                        }
                    }
                }
            }
        });
        return this.score("BOSS", testSamples, testLabels, usedLengths);
    }

    public static class BOSSModel
    extends Classifier.Model {
        public BOSS.BagOfPattern[] bag;
        public BOSS boss;
        public int features;

        public BOSSModel() {
        }

        public BOSSModel(boolean normed, int windowLength) {
            super("BOSS", -1, 1, -1, 1, normed, windowLength);
        }
    }
}

