/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.Ensemble;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;
import sfa.transformation.BOSS;
import sfa.transformation.BOSSVS;

public class BOSSVSClassifier
extends Classifier {
    public static double factor = 0.95;
    public static int maxF = 16;
    public static int minF = 4;
    public static int maxS = 4;
    public static boolean normMagnitudes = false;
    public static int MAX_WINDOW_LENGTH = 250;
    public Ensemble<BossVSModel<IntFloatHashMap>> model;

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            BOSSVSClassifier.outputResult(score.training, startTime, testSamples.length);
            System.out.println("");
        }
        int correctTesting = this.score((TimeSeries[])testSamples).correct.get();
        return new Classifier.Score("BOSS VS", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        this.generateIndices(trainSamples);
        Classifier.Score bestScore = null;
        int bestCorrectTraining = 0;
        int minWindowLength = 10;
        int maxWindowLength = this.getMax(trainSamples, MAX_WINDOW_LENGTH);
        ArrayList<Integer> windows = new ArrayList<Integer>();
        double count = Math.sqrt(maxWindowLength);
        double distance = (double)(maxWindowLength - minWindowLength) / count;
        int c = minWindowLength;
        while (c <= maxWindowLength) {
            windows.add(c);
            c = (int)((double)c + distance);
        }
        for (boolean normMean : NORMALIZATION) {
            Ensemble<BossVSModel<IntFloatHashMap>> model = this.fitEnsemble(windows.toArray(new Integer[0]), normMean, trainSamples);
            Double[] labels = this.predict(model, trainSamples);
            Classifier.Predictions pred = this.evalLabels(trainSamples, labels);
            if (bestCorrectTraining > pred.correct.get()) continue;
            bestCorrectTraining = pred.correct.get();
            bestScore = model.getHighestScoringModel().score;
            bestScore.training = pred.correct.get();
            this.model = model;
        }
        return bestScore;
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    @Override
    public Double[] predict(TimeSeries[] testSamples) {
        return this.predict(this.model, testSamples);
    }

    protected Ensemble<BossVSModel<IntFloatHashMap>> fitEnsemble(final Integer[] windows, final boolean normMean, final TimeSeries[] samples) {
        final ArrayList results = new ArrayList(windows.length);
        final AtomicInteger correctTraining = new AtomicInteger(0);
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){
            Set<Double> uniqueLabels;
            {
                this.uniqueLabels = Classifier.uniqueClassLabels(samples);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < windows.length; ++i) {
                    if (i % Classifier.threads != id) continue;
                    BossVSModel model = new BossVSModel(normMean, windows[i]);
                    try {
                        BOSSVS bossvs = new BOSSVS(maxF, maxS, windows[i], model.normed);
                        int[][] words = bossvs.createWords(samples);
                        for (int f = minF; f <= Math.min(model.windowLength, maxF); f += 2) {
                            BOSS.BagOfPattern[] bag = bossvs.createBagOfPattern(words, samples, f);
                            int correct = 0;
                            for (int s = 0; s < Classifier.folds; ++s) {
                                ObjectObjectHashMap<Double, IntFloatHashMap> idf = bossvs.createTfIdf(bag, BOSSVSClassifier.this.trainIndices[s], this.uniqueLabels);
                                correct += BOSSVSClassifier.this.predict((int[])BOSSVSClassifier.this.testIndices[s], (BOSS.BagOfPattern[])bag, idf).correct.get();
                            }
                            if (correct <= model.score.training) continue;
                            model.score.training = correct;
                            model.features = f;
                            if (correct == samples.length) break;
                        }
                        BOSS.BagOfPattern[] bag = bossvs.createBagOfPattern(words, samples, model.features);
                        model.idf = bossvs.createTfIdf(bag, this.uniqueLabels);
                        model.bossvs = bossvs;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AtomicInteger atomicInteger = correctTraining;
                    synchronized (atomicInteger) {
                        if (model.score.training > correctTraining.get()) {
                            correctTraining.set(model.score.training);
                        }
                        if ((double)model.score.training >= (double)correctTraining.get() * factor) {
                            results.add(model);
                        }
                        continue;
                    }
                }
            }
        });
        return this.filterByFactor(results, correctTraining.get(), factor);
    }

    protected Classifier.Predictions predict(final int[] indices, final BOSS.BagOfPattern[] bagOfPatternsTestSamples, final ObjectObjectHashMap<Double, IntFloatHashMap> matrixTrain) {
        final Classifier.Predictions p = new Classifier.Predictions(new Double[bagOfPatternsTestSamples.length], 0);
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i : indices) {
                    if (i % 8 != id) continue;
                    double bestDistance = 0.0;
                    for (ObjectObjectCursor classEntry : matrixTrain) {
                        Double label = (Double)classEntry.key;
                        IntFloatHashMap stat = (IntFloatHashMap)classEntry.value;
                        double distance = 0.0;
                        for (IntIntCursor wordFreq : bagOfPatternsTestSamples[i].bag) {
                            double wordInBagFreq = wordFreq.value;
                            double value = stat.get(wordFreq.key);
                            distance += wordInBagFreq * (value + 1.0);
                        }
                        if (normMagnitudes) {
                            distance /= Classifier.magnitude(stat.values());
                        }
                        if (!(distance > bestDistance)) continue;
                        bestDistance = distance;
                        p.labels[i] = label;
                    }
                    if (!BOSSVSClassifier.this.compareLabels(bagOfPatternsTestSamples[i].label, p.labels[i])) continue;
                    p.correct.incrementAndGet();
                }
            }
        });
        return p;
    }

    protected Double[] predict(final Ensemble<BossVSModel<IntFloatHashMap>> model, final TimeSeries[] testSamples) {
        final List[] testLabels = new List[testSamples.length];
        for (int i = 0; i < testLabels.length; ++i) {
            testLabels[i] = new ArrayList();
        }
        final List<Integer> usedLengths = Collections.synchronizedList(new ArrayList(model.size()));
        final int[] indicesTest = BOSSVSClassifier.createIndices(testSamples.length);
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < model.size(); ++i) {
                    if (i % Classifier.threads != id) continue;
                    BossVSModel score = (BossVSModel)model.get(i);
                    usedLengths.add(score.windowLength);
                    BOSSVS model2 = score.bossvs;
                    int[][] wordsTest = model2.createWords(testSamples);
                    BOSS.BagOfPattern[] bagTest = model2.createBagOfPattern(wordsTest, testSamples, score.features);
                    Classifier.Predictions p = BOSSVSClassifier.this.predict(indicesTest, bagTest, score.idf);
                    for (int j = 0; j < p.labels.length; ++j) {
                        List list = testLabels[j];
                        synchronized (list) {
                            testLabels[j].add(new Classifier.Pair<Double, Integer>(p.labels[j], score.score.training));
                            continue;
                        }
                    }
                }
            }
        });
        return this.score("BOSS VS", testSamples, testLabels, usedLengths);
    }

    public static class BossVSModel<E>
    extends Classifier.Model {
        public ObjectObjectHashMap<Double, E> idf;
        public BOSSVS bossvs;
        public int features;

        public BossVSModel() {
        }

        public BossVSModel(boolean normed, int windowLength) {
            super("BOSS VS", -1, 1, -1, 1, normed, windowLength);
        }
    }
}

