/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;
import sfa.classification.Ensemble;
import sfa.classification.ParallelFor;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;
import sfa.transformation.MFT;

public abstract class Classifier {
    transient ExecutorService exec = Executors.newFixedThreadPool(threads);
    public static boolean[] NORMALIZATION = new boolean[]{true, false};
    public static boolean DEBUG = false;
    public static boolean ENSEMBLE_WEIGHTS = true;
    public static int threads = 1;
    protected int[][] testIndices;
    protected int[][] trainIndices;
    public static int folds = 10;
    public static final int BLOCKS = 8;

    protected void finalize() {
        if (this.exec != null) {
            this.exec.shutdown();
        }
    }

    public abstract Score fit(TimeSeries[] var1);

    public abstract Predictions score(TimeSeries[] var1);

    public abstract Double[] predict(TimeSeries[] var1);

    public abstract Score eval(TimeSeries[] var1, TimeSeries[] var2);

    protected Predictions evalLabels(TimeSeries[] testSamples, Double[] labels) {
        int correct = 0;
        for (int ind = 0; ind < testSamples.length; ++ind) {
            correct += this.compareLabels(labels[ind], testSamples[ind].getLabel()) ? 1 : 0;
        }
        return new Predictions(labels, correct);
    }

    protected Predictions evalLabels(double[] sampleLabels, Double[] labels) {
        int correct = 0;
        for (int ind = 0; ind < sampleLabels.length; ++ind) {
            correct += this.compareLabels(labels[ind], sampleLabels[ind]) ? 1 : 0;
        }
        return new Predictions(labels, correct);
    }

    protected Predictions evalLabels(MultiVariateTimeSeries[] testSamples, Double[] labels) {
        int correct = 0;
        for (int ind = 0; ind < testSamples.length; ++ind) {
            correct += this.compareLabels(labels[ind], testSamples[ind].getLabel()) ? 1 : 0;
        }
        return new Predictions(labels, correct);
    }

    public static void outputResult(int correct, long time, int testSize) {
        double error = Classifier.formatError(correct, testSize);
        String correctStr = MessageFormat.format("{0,number,#.##%}", 1.0 - error);
        System.out.print("Correct:\t");
        System.out.print(correctStr);
        System.out.println("\tTime: \t" + (double)(System.currentTimeMillis() - time) / 1000.0 + " s");
    }

    public static double formatError(int correct, int testSize) {
        return (double)Math.round((double)(1000 * (testSize - correct)) / (double)testSize) / 1000.0;
    }

    protected static int trainLibLinear(final Problem prob, SolverType solverType, double c, int iter, double p, int nr_fold) {
        int i;
        final Parameter param = new Parameter(solverType, c, iter, p);
        ThreadLocal<Random> myRandom = new ThreadLocal<Random>();
        myRandom.set(new Random(1L));
        Random random = (Random)myRandom.get();
        final int l = prob.l;
        final int[] perm = new int[l];
        if (nr_fold > l) {
            nr_fold = l;
        }
        final int[] fold_start = new int[nr_fold + 1];
        for (i = 0; i < l; ++i) {
            perm[i] = i;
        }
        for (i = 0; i < l; ++i) {
            int j = i + random.nextInt(l - i);
            Classifier.swap(perm, i, j);
        }
        for (i = 0; i <= nr_fold; ++i) {
            fold_start[i] = i * l / nr_fold;
        }
        final AtomicInteger correct = new AtomicInteger(0);
        final int fold = nr_fold;
        ParallelFor.withIndex(threads, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                ThreadLocal<Linear> myLinear = new ThreadLocal<Linear>();
                myLinear.set(new Linear());
                Linear cfr_ignored_0 = (Linear)myLinear.get();
                Linear.disableDebugOutput();
                Linear cfr_ignored_1 = (Linear)myLinear.get();
                Linear.resetRandom();
                for (int i = 0; i < fold; ++i) {
                    int j;
                    if (i % threads != id) continue;
                    int begin = fold_start[i];
                    int end = fold_start[i + 1];
                    Problem subprob = new Problem();
                    subprob.bias = prob.bias;
                    subprob.n = prob.n;
                    subprob.l = l - (end - begin);
                    subprob.x = new Feature[subprob.l][];
                    subprob.y = new double[subprob.l];
                    int k = 0;
                    for (j = 0; j < begin; ++j) {
                        subprob.x[k] = prob.x[perm[j]];
                        subprob.y[k] = prob.y[perm[j]];
                        ++k;
                    }
                    for (j = end; j < l; ++j) {
                        subprob.x[k] = prob.x[perm[j]];
                        subprob.y[k] = prob.y[perm[j]];
                        ++k;
                    }
                    Linear cfr_ignored_2 = (Linear)myLinear.get();
                    de.bwaldvogel.liblinear.Model submodel = Linear.train(subprob, param);
                    for (j = begin; j < end; ++j) {
                        Linear cfr_ignored_3 = (Linear)myLinear.get();
                        correct.addAndGet(prob.y[perm[j]] == Linear.predict(submodel, prob.x[perm[j]]) ? 1 : 0);
                    }
                }
            }
        });
        return correct.get();
    }

    private static void swap(int[] array, int idxA, int idxB) {
        int temp = array[idxA];
        array[idxA] = array[idxB];
        array[idxB] = temp;
    }

    public static void trainSVMOneClass(final svm_problem prob, final svm_parameter param, int nr_fold, final Double[] target, Random rand) {
        int i;
        final int[] fold_start = new int[nr_fold + 1];
        final int l = prob.l;
        final int[] perm = new int[l];
        for (i = 0; i < l; ++i) {
            perm[i] = i;
        }
        for (i = 0; i < l; ++i) {
            int j = i + rand.nextInt(l - i);
            int tmp = perm[i];
            perm[i] = perm[j];
            perm[j] = tmp;
        }
        for (i = 0; i <= nr_fold; ++i) {
            fold_start[i] = i * l / nr_fold;
        }
        final int fold = nr_fold;
        ParallelFor.withIndex(threads, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                final ThreadLocal<svm> mySVM = new ThreadLocal<svm>();
                mySVM.set(new svm());
                for (int i = 0; i < fold; ++i) {
                    int j;
                    if (i % threads != id) continue;
                    final int begin = fold_start[i];
                    final int end = fold_start[i + 1];
                    svm_problem subprob = new svm_problem();
                    subprob.l = l - (end - begin);
                    subprob.x = new svm_node[subprob.l][];
                    subprob.y = new double[subprob.l];
                    int k = 0;
                    for (j = 0; j < begin; ++j) {
                        subprob.x[k] = prob.x[perm[j]];
                        subprob.y[k] = prob.y[perm[j]];
                        ++k;
                    }
                    for (j = end; j < l; ++j) {
                        subprob.x[k] = prob.x[perm[j]];
                        subprob.y[k] = prob.y[perm[j]];
                        ++k;
                    }
                    svm cfr_ignored_0 = (svm)mySVM.get();
                    final svm_model submodel = svm.svm_train(subprob, param);
                    ParallelFor.withIndex(8, new ParallelFor.Each(){

                        @Override
                        public void run(int id, AtomicInteger processed) {
                            for (int j = begin; j < end; ++j) {
                                if (j % 8 != id) continue;
                                svm cfr_ignored_0 = (svm)mySVM.get();
                                target[perm[j]] = svm.svm_predict(submodel, prob.x[perm[j]]);
                            }
                        }
                    });
                }
            }
        });
    }

    protected boolean compareLabels(Double label1, Double label2) {
        return label1 != null && label2 != null && label1.equals(label2);
    }

    protected <E extends Model> Ensemble<E> filterByFactor(List<E> results, int correctTraining, double factor) {
        Collections.sort(results, Collections.reverseOrder());
        ArrayList<Model> model = new ArrayList<Model>();
        for (Model score : results) {
            if (!((double)score.score.training >= (double)correctTraining * factor)) continue;
            model.add(score);
        }
        return new Ensemble(model);
    }

    protected Double[] score(String name, TimeSeries[] samples, List<Pair<Double, Integer>>[] labels, List<Integer> currentWindowLengths) {
        Double[] predictedLabels = new Double[samples.length];
        for (int i = 0; i < labels.length; ++i) {
            HashMap<Double, Long> counts = new HashMap<Double, Long>();
            for (Pair<Double, Integer> k : labels[i]) {
                if (k == null || k.key == null) continue;
                Double label = (Double)k.key;
                Long count = (Long)counts.get(label);
                long increment = ENSEMBLE_WEIGHTS ? (long)((Integer)k.value).intValue() : 1L;
                count = count == null ? increment : count + increment;
                counts.put(label, count);
            }
            long maxCount = -1L;
            for (Map.Entry e : counts.entrySet()) {
                if (predictedLabels[i] != null && maxCount >= (Long)e.getValue() && (maxCount != (Long)e.getValue() || !(predictedLabels[i] <= (Double)e.getKey()))) continue;
                maxCount = (Long)e.getValue();
                predictedLabels[i] = (Double)e.getKey();
            }
        }
        if (DEBUG) {
            System.out.print(name + " Testing with " + currentWindowLengths.size() + " models:\t");
            System.out.println(currentWindowLengths.toString() + "\n");
        }
        return predictedLabels;
    }

    protected Integer[] getWindowsBetween(int minWindowLength, int maxWindowLength) {
        ArrayList<Integer> windows = new ArrayList<Integer>();
        for (int windowLength = maxWindowLength; windowLength >= minWindowLength; --windowLength) {
            windows.add(windowLength);
        }
        return windows.toArray(new Integer[0]);
    }

    protected int getMax(TimeSeries[] samples, int maxWindowSize) {
        int max = 0;
        for (TimeSeries ts : samples) {
            max = Math.max(ts.getLength(), max);
        }
        return Math.min(maxWindowSize, max);
    }

    protected static Set<Double> uniqueClassLabels(TimeSeries[] ts) {
        HashSet<Double> labels = new HashSet<Double>();
        for (TimeSeries t : ts) {
            labels.add(t.getLabel());
        }
        return labels;
    }

    protected static double magnitude(FloatContainer values) {
        double mag = 0.0;
        for (FloatCursor value : values) {
            mag += (double)(value.value * value.value);
        }
        return Math.sqrt(mag);
    }

    protected static int[] createIndices(int length) {
        int[] indices = new int[length];
        for (int i = 0; i < length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    protected void generateIndices(TimeSeries[] samples) {
        IntArrayList[] sets = this.getStratifiedTrainTestSplitIndices(samples, folds);
        this.testIndices = new int[folds][];
        this.trainIndices = new int[folds][];
        for (int s = 0; s < folds; ++s) {
            this.testIndices[s] = Classifier.convertToInt(sets[s]);
            this.trainIndices[s] = Classifier.convertToInt(sets, s);
        }
    }

    protected IntArrayList[] getStratifiedTrainTestSplitIndices(TimeSeries[] samples, int splits) {
        HashMap<Double, IntArrayDeque> elements = new HashMap<Double, IntArrayDeque>();
        for (int i = 0; i < samples.length; ++i) {
            Double label = samples[i].getLabel();
            IntArrayDeque sameLabel = (IntArrayDeque)elements.get(label);
            if (sameLabel == null) {
                sameLabel = new IntArrayDeque();
                elements.put(label, sameLabel);
            }
            sameLabel.addLast(i);
        }
        IntArrayList[] sets = new IntArrayList[splits];
        for (int i = 0; i < splits; ++i) {
            sets[i] = new IntArrayList();
        }
        block2: for (Map.Entry data : elements.entrySet()) {
            IntArrayDeque d = (IntArrayDeque)data.getValue();
            block3: while (true) {
                int s = 0;
                while (true) {
                    if (s >= splits) continue block3;
                    if (d.isEmpty()) continue block2;
                    int dd = d.removeFirst();
                    sets[s].add(dd);
                    ++s;
                }
                break;
            }
        }
        return sets;
    }

    protected static int[] convertToInt(IntArrayList trainSet) {
        int[] train = new int[trainSet.size()];
        int a = 0;
        for (IntCursor i : trainSet) {
            train[a++] = i.value;
        }
        return train;
    }

    protected static int[] convertToInt(IntArrayList[] setToSplit, int exclude) {
        int count = 0;
        for (int i = 0; i < setToSplit.length; ++i) {
            if (i == exclude) continue;
            count += setToSplit[i].size();
        }
        int[] setData = new int[count];
        int a = 0;
        for (int i = 0; i < setToSplit.length; ++i) {
            if (i == exclude) continue;
            for (IntCursor d : setToSplit[i]) {
                setData[a++] = d.value;
            }
        }
        return setData;
    }

    public void save(File file) throws FileNotFoundException {
        Output kryoOutput = new Output(new FileOutputStream(file));
        Kryo kryo = Classifier.initKryo();
        kryo.writeClassAndObject(kryoOutput, this);
        kryoOutput.close();
    }

    private static Kryo initKryo() {
        Kryo kryo = new Kryo();
        kryo.register(MFT.class, new MFT.MFTKryoSerializer(kryo));
        return kryo;
    }

    public static <T extends Classifier> T load(File file) throws FileNotFoundException {
        Input kryoInput = new Input(new FileInputStream(file));
        Kryo kryo = Classifier.initKryo();
        Classifier classifier = (Classifier)kryo.readClassAndObject(kryoInput);
        return (T)classifier;
    }

    private long getGcCount() {
        long sum = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = b.getCollectionCount();
            if (count == -1L) continue;
            sum += count;
        }
        return sum;
    }

    public long getUsedMemory() {
        long before = this.getGcCount();
        System.gc();
        while (this.getGcCount() == before) {
        }
        return this.getCurrentlyAllocatedMemory();
    }

    private long getCurrentlyAllocatedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        threads = runtime.availableProcessors() <= 4 ? runtime.availableProcessors() - 1 : runtime.availableProcessors();
    }

    public static class Pair<E, T> {
        public E key;
        public T value;

        public Pair(E e, T t) {
            this.key = e;
            this.value = t;
        }

        public static <E, T> Pair<E, T> create(E e, T t) {
            return new Pair<E, T>(e, t);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            return this.key.equals(((Pair)obj).key);
        }
    }

    public static class Predictions {
        public Double[] labels;
        public AtomicInteger correct;
        public double[][] probabilities;
        public int[] realLabels;

        public Predictions(Double[] labels, int bestCorrect) {
            this.labels = labels;
            this.correct = new AtomicInteger(bestCorrect);
        }

        public Predictions(Double[] predictions, double[][] probabilities, int[] realLabels) {
            this.labels = predictions;
            this.probabilities = probabilities;
            this.realLabels = realLabels;
        }
    }

    public static class Score
    implements Comparable<Score> {
        public String name;
        public int training;
        public int trainSize;
        public int testing;
        public int testSize;
        public int windowLength;
        public Double avgOffset;

        public Score() {
        }

        public Score(String name, int testing, int testSize, int training, int trainSize, int windowLength) {
            this.name = name;
            this.training = training;
            this.trainSize = trainSize;
            this.testing = testing;
            this.testSize = testSize;
            this.windowLength = windowLength;
        }

        public double getTestingAccuracy() {
            return 1.0 - Classifier.formatError(this.testing, this.testSize);
        }

        public double getTrainingAccuracy() {
            return 1.0 - Classifier.formatError(this.training, this.trainSize);
        }

        public Double getTestEarliness() {
            return this.avgOffset;
        }

        public String getEarliness() {
            return String.format(Locale.ENGLISH, "%.2f", this.avgOffset);
        }

        public String toString() {
            double test = this.getTestingAccuracy();
            double train = this.getTrainingAccuracy();
            if (this.avgOffset != null) {
                String earliness = this.getEarliness();
                return this.name + ";" + train + ";" + test + ";" + earliness;
            }
            return this.name + ";" + train + ";" + test;
        }

        @Override
        public int compareTo(Score bestScore) {
            if (this.training > bestScore.training || this.training == bestScore.training && this.windowLength > bestScore.windowLength) {
                return 1;
            }
            return -1;
        }

        public void clear() {
            this.testing = 0;
            this.training = 0;
        }
    }

    public static class Model
    implements Comparable<Model> {
        public String name;
        public int windowLength;
        public boolean normed;
        public Score score;

        public Model() {
        }

        public Model(String name, int testing, int testSize, int training, int trainSize, boolean normed, int windowLength) {
            this(name, new Score(name, testing, testSize, training, trainSize, windowLength), normed, windowLength);
        }

        public Model(String name, Score score, boolean normed, int windowLength) {
            this.name = name;
            this.score = score;
            this.normed = normed;
            this.windowLength = windowLength;
        }

        public String toString() {
            return this.score.toString();
        }

        @Override
        public int compareTo(Model bestScore) {
            return this.score.compareTo(bestScore.score);
        }
    }

    public static class Words {
        public static int binlog(int bits) {
            int log = 0;
            if ((bits & 0xFFFF0000) != 0) {
                bits >>>= 16;
                log = 16;
            }
            if (bits >= 256) {
                bits >>>= 8;
                log += 8;
            }
            if (bits >= 16) {
                bits >>>= 4;
                log += 4;
            }
            if (bits >= 4) {
                bits >>>= 2;
                log += 2;
            }
            return log + (bits >>> 1);
        }

        public static long createWord(short[] words, int features, byte usedBits) {
            return Words.fromByteArrayOne(words, features, usedBits);
        }

        public static long fromByteArrayOne(short[] bytes, int to, byte usedBits) {
            int shortsPerLong = 60 / usedBits;
            to = Math.min(bytes.length, to);
            long bits = 0L;
            int start = 0;
            long shiftOffset = 1L;
            int end = Math.min(to, shortsPerLong + start);
            for (int i = start; i < end; ++i) {
                int j = 0;
                int shift = 1;
                while (j < usedBits) {
                    if ((bytes[i] & shift) != 0) {
                        bits |= shiftOffset;
                    }
                    shiftOffset <<= 1;
                    ++j;
                    shift <<= 1;
                }
            }
            return bits;
        }
    }
}

