/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import com.carrotsearch.hppc.ObjectIntAssociativeContainer;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import sfa.classification.Classifier;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;
import sfa.transformation.MUSE;
import sfa.transformation.SFA;

public class MUSEClassifier
extends Classifier {
    public static int maxF = 6;
    public static int minF = 2;
    public static int maxS = 4;
    public static SFA.HistogramType[] histTypes = new SFA.HistogramType[]{SFA.HistogramType.EQUI_DEPTH, SFA.HistogramType.EQUI_FREQUENCY};
    public static double chi = 2.0;
    public static double bias = 1.0;
    public static SolverType solverType = SolverType.L2R_LR;
    public static int iterations = 5000;
    public static double p = 0.1;
    public static double c = 1.0;
    public static boolean BIGRAMS = true;
    public static boolean lowerBounding = false;
    public static int MIN_WINDOW_LENGTH = 2;
    public static int MAX_WINDOW_LENGTH = 450;
    MUSEModel model;

    public MUSEClassifier() {
        TimeSeries.APPLY_Z_NORM = false;
    }

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        throw new RuntimeException("Please use: eval(final MultiVariateTimeSeries[] trainSamples, final MultiVariateTimeSeries[] testSamples)");
    }

    @Override
    public Double[] predict(TimeSeries[] samples) {
        throw new RuntimeException("Please use: predict(final MultiVariateTimeSeries[] samples)");
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        throw new RuntimeException("Please use: fit(final MultiVariateTimeSeries[] trainSamples)");
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        throw new RuntimeException("Please use: score(final MultiVariateTimeSeries[] testSamples)");
    }

    public Classifier.Score eval(MultiVariateTimeSeries[] trainSamples, MultiVariateTimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            MUSEClassifier.outputResult(score.training, startTime, trainSamples.length);
        }
        int correctTesting = this.score((MultiVariateTimeSeries[])testSamples).correct.get();
        if (DEBUG) {
            System.out.println("WEASEL+MUSE Testing:\t");
            MUSEClassifier.outputResult(correctTesting, startTime, testSamples.length);
            System.out.println("");
        }
        return new Classifier.Score("WEASEL+MUSE", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    public Classifier.Score fit(MultiVariateTimeSeries[] trainSamples) {
        this.model = this.fitMuse(trainSamples);
        return this.model.score;
    }

    public Classifier.Predictions score(MultiVariateTimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    public int getMax(MultiVariateTimeSeries[] samples, int MAX_WINDOW_SIZE) {
        int max = samples[0].timeSeries[0].getLength();
        for (MultiVariateTimeSeries mts : samples) {
            for (TimeSeries ts : mts.timeSeries) {
                max = Math.max(ts.getLength(), max);
            }
        }
        return Math.min(max, MAX_WINDOW_SIZE);
    }

    public MUSEModel fitMuse(MultiVariateTimeSeries[] samples) {
        int dimensionality = samples[0].getDimensions();
        try {
            int maxCorrect = -1;
            int bestF = -1;
            boolean bestNorm = false;
            SFA.HistogramType bestHistType = null;
            block2: for (SFA.HistogramType histType : histTypes) {
                for (boolean mean : NORMALIZATION) {
                    int[] windowLengths = this.getWindowLengths(samples, mean);
                    for (int f = minF; f <= maxF; f += 2) {
                        MUSE model = new MUSE(f, maxS, histType, windowLengths, mean, lowerBounding);
                        MUSE.BagOfBigrams[] bag = null;
                        for (int w = 0; w < model.windowLengths.length; ++w) {
                            int[][] words = model.createWords(samples, w);
                            MUSE.BagOfBigrams[] bobForOneWindow = this.fitOneWindow(samples, windowLengths, mean, histType, model, words, f, dimensionality, w);
                            bag = this.mergeBobs(bag, bobForOneWindow);
                        }
                        Problem problem = MUSEClassifier.initLibLinearProblem(bag, model.dict, bias);
                        int correct = MUSEClassifier.trainLibLinear(problem, solverType, c, iterations, p, folds);
                        if (correct > maxCorrect || correct == maxCorrect && f < bestF) {
                            maxCorrect = correct;
                            bestF = f;
                            bestNorm = mean;
                            bestHistType = histType;
                            if (DEBUG) {
                                System.out.println("New best model" + maxCorrect + " " + bestF + " " + bestNorm + " " + bestHistType);
                            }
                        }
                        if (correct == samples.length) break block2;
                    }
                }
            }
            int[] windowLengths = this.getWindowLengths(samples, bestNorm);
            MUSE model = new MUSE(bestF, maxS, bestHistType, windowLengths, bestNorm, lowerBounding);
            MUSE.BagOfBigrams[] bob = null;
            for (int w = 0; w < model.windowLengths.length; ++w) {
                int[][] words = model.createWords(samples, w);
                MUSE.BagOfBigrams[] bobForOneWindow = this.fitOneWindow(samples, windowLengths, bestNorm, bestHistType, model, words, bestF, dimensionality, w);
                bob = this.mergeBobs(bob, bobForOneWindow);
            }
            Problem problem = MUSEClassifier.initLibLinearProblem(bob, model.dict, bias);
            Parameter par = new Parameter(solverType, c, iterations, p);
            Model linearModel = Linear.train(problem, par);
            return new MUSEModel(bestNorm, bestF, bestHistType, model, linearModel, 0, 1, maxCorrect, samples.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private MUSE.BagOfBigrams[] fitOneWindow(MultiVariateTimeSeries[] samples, int[] windowLengths, boolean mean, SFA.HistogramType histType, MUSE model, int[][] word, int f, int dimensionality, int w) {
        MUSE modelForWindow = new MUSE(f, maxS, histType, windowLengths, mean, lowerBounding);
        MUSE.BagOfBigrams[] bopForWindow = modelForWindow.createBagOfPatterns(word, samples, w, dimensionality, f);
        modelForWindow.trainChiSquared(bopForWindow, chi);
        model.dict.dictChi.putAll((ObjectIntAssociativeContainer<MUSE.MuseWord>)modelForWindow.dict.dictChi);
        return bopForWindow;
    }

    private MUSE.BagOfBigrams[] mergeBobs(MUSE.BagOfBigrams[] bop, MUSE.BagOfBigrams[] bopForWindow) {
        if (bop == null) {
            bop = bopForWindow;
        } else {
            for (int i = 0; i < bop.length; ++i) {
                bop[i].bob.putAll((ObjectIntAssociativeContainer<MUSE.MuseWord>)bopForWindow[i].bob);
            }
        }
        return bop;
    }

    public int[] getWindowLengths(MultiVariateTimeSeries[] samples, boolean norm) {
        int min = norm && MIN_WINDOW_LENGTH <= 2 ? Math.max(3, MIN_WINDOW_LENGTH) : MIN_WINDOW_LENGTH;
        int max = this.getMax(samples, MAX_WINDOW_LENGTH);
        int[] windowLengths = new int[max - min + 1];
        int w = min;
        int a = 0;
        while (w <= max) {
            windowLengths[a] = w++;
            ++a;
        }
        return windowLengths;
    }

    public Double[] predict(MultiVariateTimeSeries[] samples) {
        int dimensionality = samples[0].getDimensions();
        MUSE.BagOfBigrams[] bagTest = null;
        for (int w = 0; w < this.model.muse.windowLengths.length; ++w) {
            int[][] wordsTest = this.model.muse.createWords(samples, w);
            MUSE.BagOfBigrams[] bopForWindow = this.model.muse.createBagOfPatterns(wordsTest, samples, w, dimensionality, this.model.features);
            this.model.muse.dict.filterChiSquared(bopForWindow);
            bagTest = this.mergeBobs(bagTest, bopForWindow);
        }
        FeatureNode[][] features = MUSEClassifier.initLibLinear(bagTest, this.model.muse.dict);
        Double[] labels = new Double[samples.length];
        for (int ind = 0; ind < features.length; ++ind) {
            double label = Linear.predict(this.model.linearModel, features[ind]);
            labels[ind] = label;
        }
        return labels;
    }

    public static Problem initLibLinearProblem(MUSE.BagOfBigrams[] bob, MUSE.Dictionary dict, double bias) {
        Linear.resetRandom();
        Problem problem = new Problem();
        problem.bias = bias;
        problem.y = MUSEClassifier.getLabels(bob);
        FeatureNode[][] features = MUSEClassifier.initLibLinear(bob, dict);
        problem.n = dict.size() + 1;
        problem.l = features.length;
        problem.x = features;
        return problem;
    }

    public static double[] getLabels(MUSE.BagOfBigrams[] bagOfPatternsTestSamples) {
        double[] labels = new double[bagOfPatternsTestSamples.length];
        for (int i = 0; i < bagOfPatternsTestSamples.length; ++i) {
            labels[i] = bagOfPatternsTestSamples[i].label;
        }
        return labels;
    }

    protected static FeatureNode[][] initLibLinear(MUSE.BagOfBigrams[] bob, MUSE.Dictionary dict) {
        FeatureNode[][] featuresTrain = new FeatureNode[bob.length][];
        for (int j = 0; j < bob.length; ++j) {
            MUSE.BagOfBigrams bop = bob[j];
            ArrayList<FeatureNode> features = new ArrayList<FeatureNode>(bop.bob.size());
            for (ObjectIntCursor<MUSE.MuseWord> objectIntCursor : bop.bob) {
                if (objectIntCursor.value <= 0) continue;
                features.add(new FeatureNode(dict.getWordChi((MUSE.MuseWord)objectIntCursor.key), objectIntCursor.value));
            }
            FeatureNode[] featuresArray = features.toArray(new FeatureNode[0]);
            Arrays.parallelSort(featuresArray, new Comparator<FeatureNode>(){

                @Override
                public int compare(FeatureNode o1, FeatureNode o2) {
                    return Integer.compare(o1.index, o2.index);
                }
            });
            featuresTrain[j] = featuresArray;
        }
        return featuresTrain;
    }

    public static class MUSEModel
    extends Classifier.Model {
        public int features;
        public MUSE muse;
        public Model linearModel;
        public SFA.HistogramType histType;

        public MUSEModel() {
        }

        public MUSEModel(boolean normed, int features, SFA.HistogramType histType, MUSE model, Model linearModel, int testing, int testSize, int training, int trainSize) {
            super("WEASEL+MUSE", testing, testSize, training, trainSize, normed, -1);
            this.features = features;
            this.muse = model;
            this.linearModel = linearModel;
            this.histType = histType;
        }
    }
}

