/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelFor {
    private static int CPUs = Math.min(Runtime.getRuntime().availableProcessors(), 40);
    private static ExecutorService executor = Executors.newFixedThreadPool(CPUs);

    public static int withIndex(ExecutorService executor, int chunksize, final Each body) {
        final CountDownLatch latch = new CountDownLatch(chunksize);
        final AtomicInteger processed = new AtomicInteger(0);
        LinkedList futures = new LinkedList();
        int i = 0;
        while (i < chunksize) {
            final int ii = i++;
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        body.run(ii, processed);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }));
        }
        try {
            latch.await();
            while (!futures.isEmpty()) {
                ((Future)futures.removeFirst()).get();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed.get();
    }

    public static int withIndex(int stop, Each body) {
        return ParallelFor.withIndex(executor, stop, body);
    }

    public static void shutdown() {
        executor.shutdown();
    }

    public static interface Each {
        public void run(int var1, AtomicInteger var2);
    }
}

