/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.Ensemble;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;

public class ShotgunClassifier
extends Classifier {
    ShotgunModel model;
    public static int MAX_WINDOW_LENGTH = 250;

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            ShotgunClassifier.outputResult(score.training, startTime, trainSamples.length);
        }
        int correctTesting = this.score((TimeSeries[])testSamples).correct.get();
        if (DEBUG) {
            System.out.println("Shotgun Testing:\t");
            ShotgunClassifier.outputResult(correctTesting, startTime, testSamples.length);
            System.out.println("");
        }
        return new Classifier.Score("Shotgun", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        Classifier.Score bestScore = null;
        int bestCorrectTraining = 0;
        for (boolean normMean : NORMALIZATION) {
            ShotgunModel model = this.fitEnsemble(trainSamples, normMean, 1.0).getHighestScoringModel();
            Classifier.Score score = model.score;
            if (this.model != null && bestCorrectTraining >= score.training) continue;
            bestCorrectTraining = score.training;
            bestScore = score;
            this.model = model;
        }
        return bestScore;
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    protected Ensemble<ShotgunModel> fitEnsemble(final TimeSeries[] trainSamples, final boolean normMean, final double factor) {
        int minWindowLength = 5;
        int maxWindowLength = this.getMax(trainSamples, MAX_WINDOW_LENGTH);
        final Integer[] windows = this.getWindowsBetween(minWindowLength, maxWindowLength);
        final AtomicInteger correctTraining = new AtomicInteger(0);
        final ArrayList results = new ArrayList(windows.length);
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < windows.length; ++i) {
                    if (i % Classifier.threads != id) continue;
                    ShotgunModel model = new ShotgunModel(normMean, windows[i], trainSamples);
                    Double[] labels = ShotgunClassifier.this.predict(model, trainSamples);
                    Classifier.Predictions p = ShotgunClassifier.this.evalLabels(trainSamples, labels);
                    model.score = new Classifier.Score(model.name, -1, 1, p.correct.get(), trainSamples.length, windows[i]);
                    AtomicInteger atomicInteger = correctTraining;
                    synchronized (atomicInteger) {
                        if (model.score.training > correctTraining.get()) {
                            correctTraining.set(model.score.training);
                        }
                        if ((double)model.score.training >= (double)correctTraining.get() * factor) {
                            results.add(model);
                        }
                        continue;
                    }
                }
            }
        });
        return this.filterByFactor(results, correctTraining.get(), factor);
    }

    @Override
    public Double[] predict(TimeSeries[] testSamples) {
        return this.predict(this.model, testSamples);
    }

    protected Double[] predict(final ShotgunModel model, final TimeSeries[] testSamples) {
        final Double[] p = new Double[testSamples.length];
        final double[][] means = new double[model.samples.length][];
        final double[][] stds = new double[model.samples.length][];
        ShotgunClassifier.calcMeansStds(model.windowLength, model.samples, means, stds, model.normed);
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < testSamples.length; ++i) {
                    if (i % 8 != id) continue;
                    TimeSeries query = testSamples[i];
                    double distanceTo1NN = Double.MAX_VALUE;
                    int wQueryLen = Math.min(query.getLength(), model.windowLength);
                    TimeSeries[] disjointWindows = query.getDisjointSequences(wQueryLen, model.normed);
                    for (int j = 0; j < model.samples.length; ++j) {
                        TimeSeries ts = model.samples[j];
                        if (ts == query) continue;
                        double totalDistance = 0.0;
                        for (TimeSeries q : disjointWindows) {
                            double resultDistance = distanceTo1NN;
                            int end = ts.getLength() - model.windowLength + 1;
                            for (int ww = 0; ww < end; ++ww) {
                                double distance = ShotgunClassifier.getEuclideanDistance(ts, q, means[j][ww], stds[j][ww], resultDistance, ww);
                                resultDistance = Math.min(distance, resultDistance);
                            }
                            if ((totalDistance += resultDistance) > distanceTo1NN) break;
                        }
                        if (!(totalDistance < distanceTo1NN)) continue;
                        p[i] = ts.getLabel();
                        distanceTo1NN = totalDistance;
                    }
                }
            }
        });
        return p;
    }

    protected static double getEuclideanDistance(TimeSeries ts, TimeSeries q, double meanTs, double stdTs, double minValue, int w) {
        double distance = 0.0;
        double[] tsData = ts.getData();
        double[] qData = q.getData();
        for (int ww = 0; ww < qData.length; ++ww) {
            double value1 = (tsData[w + ww] - meanTs) * stdTs;
            double value = qData[ww] - value1;
            if (!((distance += value * value) >= minValue)) continue;
            return Double.MAX_VALUE;
        }
        return distance;
    }

    protected static void calcMeansStds(int windowLength, TimeSeries[] trainSamples, double[][] means, double[][] stds, boolean normMean) {
        for (int i = 0; i < trainSamples.length; ++i) {
            int w = Math.min(windowLength, trainSamples[i].getLength());
            means[i] = new double[trainSamples[i].getLength() - w + 1];
            stds[i] = new double[trainSamples[i].getLength() - w + 1];
            TimeSeries.calcIncrementalMeanStddev(w, trainSamples[i].getData(), means[i], stds[i]);
            for (int j = 0; j < stds[i].length; ++j) {
                stds[i][j] = stds[i][j] > 0.0 ? 1.0 / stds[i][j] : 1.0;
                means[i][j] = normMean ? means[i][j] : 0.0;
            }
        }
    }

    public static class ShotgunModel
    extends Classifier.Model {
        public TimeSeries[] samples;

        public ShotgunModel() {
        }

        public ShotgunModel(boolean normed, int windowLength, TimeSeries[] samples) {
            super("Shotgun", -1, 1, -1, 1, normed, windowLength);
            this.samples = samples;
        }
    }
}

