/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.Ensemble;
import sfa.classification.ParallelFor;
import sfa.classification.ShotgunClassifier;
import sfa.timeseries.TimeSeries;

public class ShotgunEnsembleClassifier
extends ShotgunClassifier {
    public static double factor = 0.92;
    Ensemble<ShotgunClassifier.ShotgunModel> model;

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            ShotgunEnsembleClassifier.outputResult(score.training, startTime, testSamples.length);
            System.out.println("");
        }
        int correctTesting = this.score((TimeSeries[])testSamples).correct.get();
        return new Classifier.Score("Shotgun Ensemble", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        Classifier.Score bestScore = null;
        int bestCorrectTraining = 0;
        for (boolean normMean : NORMALIZATION) {
            Ensemble<ShotgunClassifier.ShotgunModel> model = this.fitEnsemble(trainSamples, normMean, factor);
            Double[] labels = this.predict(model, trainSamples);
            Classifier.Predictions pred = this.evalLabels(trainSamples, labels);
            if (model != null && bestCorrectTraining > pred.correct.get()) continue;
            bestCorrectTraining = pred.correct.get();
            bestScore = model.getHighestScoringModel().score;
            bestScore.training = pred.correct.get();
            this.model = model;
        }
        return bestScore;
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    @Override
    public Double[] predict(TimeSeries[] testSamples) {
        return this.predict(this.model, testSamples);
    }

    protected Double[] predict(final Ensemble<ShotgunClassifier.ShotgunModel> model, final TimeSeries[] testSamples) {
        final List[] testLabels = new List[testSamples.length];
        for (int i = 0; i < testLabels.length; ++i) {
            testLabels[i] = new ArrayList();
        }
        final List<Integer> usedLengths = Collections.synchronizedList(new ArrayList(model.model.size()));
        ParallelFor.withIndex(this.exec, threads, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < model.model.size(); ++i) {
                    if (i % Classifier.threads != id) continue;
                    ShotgunClassifier.ShotgunModel score = (ShotgunClassifier.ShotgunModel)model.model.get(i);
                    usedLengths.add(score.windowLength);
                    Double[] labels = ShotgunEnsembleClassifier.this.predict(score, testSamples);
                    for (int a = 0; a < labels.length; ++a) {
                        testLabels[a].add(new Classifier.Pair<Double, Integer>(labels[a], score.score.training));
                    }
                }
            }
        });
        return this.score("Shotgun Ensemble", testSamples, testLabels, usedLengths);
    }
}

