/*
 * Decompiled with CFR 0.152.
 */
package sfa.classification;

import com.carrotsearch.hppc.cursors.LongIntCursor;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;
import sfa.transformation.WEASEL;

public class WEASELClassifier
extends Classifier {
    public static int maxF = 6;
    public static int minF = 4;
    public static int maxS = 4;
    public static SolverType solverType = SolverType.L2R_LR_DUAL;
    public static double chi = 2.0;
    public static double bias = 1.0;
    public static double p = 0.1;
    public static int iterations = 5000;
    public static double c = 1.0;
    public static boolean lowerBounding = false;
    public static int MIN_WINDOW_LENGTH = 2;
    public static int MAX_WINDOW_LENGTH = 350;
    WEASELModel model;

    public WEASELClassifier() {
        Linear.resetRandom();
        Linear.disableDebugOutput();
    }

    @Override
    public Classifier.Score eval(TimeSeries[] trainSamples, TimeSeries[] testSamples) {
        long startTime = System.currentTimeMillis();
        Classifier.Score score = this.fit(trainSamples);
        if (DEBUG) {
            System.out.println(score.toString());
            WEASELClassifier.outputResult(score.training, startTime, trainSamples.length);
        }
        int correctTesting = this.score((TimeSeries[])testSamples).correct.get();
        if (DEBUG) {
            System.out.println("WEASEL Testing:\t");
            WEASELClassifier.outputResult(correctTesting, startTime, testSamples.length);
            System.out.println("");
        }
        return new Classifier.Score("WEASEL", correctTesting, testSamples.length, score.training, trainSamples.length, score.windowLength);
    }

    @Override
    public Classifier.Score fit(TimeSeries[] trainSamples) {
        this.model = this.fitWeasel(trainSamples);
        return this.model.score;
    }

    @Override
    public Classifier.Predictions score(TimeSeries[] testSamples) {
        Double[] labels = this.predict(testSamples);
        return this.evalLabels(testSamples, labels);
    }

    @Override
    public Double[] predict(final TimeSeries[] samples) {
        final WEASEL.BagOfBigrams[] bagTest = new WEASEL.BagOfBigrams[samples.length];
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int w = 0; w < WEASELClassifier.this.model.weasel.windowLengths.length; ++w) {
                    if (w % 8 != id) continue;
                    int[][] wordsTest = WEASELClassifier.this.model.weasel.createWords(samples, w);
                    WEASEL.BagOfBigrams[] bopForWindow = WEASELClassifier.this.model.weasel.createBagOfPatterns(wordsTest, samples, w, WEASELClassifier.this.model.features);
                    WEASELClassifier.this.model.weasel.dict.filterChiSquared(bopForWindow);
                    WEASELClassifier.this.mergeBobs(bagTest, bopForWindow);
                }
            }
        });
        final FeatureNode[][] features = WEASELClassifier.initLibLinear(bagTest, this.model.weasel.dict);
        final Double[] labels = new Double[samples.length];
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int ind = 0; ind < features.length; ++ind) {
                    if (ind % 8 != id) continue;
                    double label = Linear.predict(WEASELClassifier.this.model.linearModel, features[ind]);
                    labels[ind] = label;
                }
            }
        });
        return labels;
    }

    public Classifier.Predictions predictProbabilities(final TimeSeries[] samples) {
        final Double[] labels = new Double[samples.length];
        final double[][] probabilities = new double[samples.length][];
        final WEASEL.BagOfBigrams[] bagTest = new WEASEL.BagOfBigrams[samples.length];
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int w = 0; w < WEASELClassifier.this.model.weasel.windowLengths.length; ++w) {
                    if (w % 8 != id) continue;
                    int[][] wordsTest = WEASELClassifier.this.model.weasel.createWords(samples, w);
                    WEASEL.BagOfBigrams[] bopForWindow = WEASELClassifier.this.model.weasel.createBagOfPatterns(wordsTest, samples, w, WEASELClassifier.this.model.features);
                    WEASELClassifier.this.model.weasel.dict.filterChiSquared(bopForWindow);
                    WEASELClassifier.this.mergeBobs(bagTest, bopForWindow);
                }
            }
        });
        final FeatureNode[][] features = WEASELClassifier.initLibLinear(bagTest, this.model.weasel.dict);
        ParallelFor.withIndex(8, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int ind = 0; ind < features.length; ++ind) {
                    if (ind % 8 != id) continue;
                    probabilities[ind] = new double[WEASELClassifier.this.model.linearModel.getNrClass()];
                    labels[ind] = Linear.predictProbability(WEASELClassifier.this.model.linearModel, features[ind], probabilities[ind]);
                }
            }
        });
        return new Classifier.Predictions(labels, probabilities, this.model.linearModel.getLabels());
    }

    public int[] getWindowLengths(TimeSeries[] samples, boolean norm) {
        int min = norm && MIN_WINDOW_LENGTH <= 2 ? Math.max(3, MIN_WINDOW_LENGTH) : MIN_WINDOW_LENGTH;
        int max = this.getMax(samples, MAX_WINDOW_LENGTH);
        int[] wLengths = new int[max - min + 1];
        int a = 0;
        int w = min;
        while (w <= max) {
            wLengths[a] = w++;
            ++a;
        }
        return Arrays.copyOfRange(wLengths, 0, a);
    }

    protected WEASELModel fitWeasel(final TimeSeries[] samples) {
        try {
            boolean mean2;
            int maxCorrect = -1;
            int bestF = -1;
            boolean bestNorm = false;
            block2: for (final boolean mean2 : NORMALIZATION) {
                int[] windowLengths = this.getWindowLengths(samples, mean2);
                final WEASEL model = new WEASEL(maxF, maxS, windowLengths, mean2, lowerBounding);
                final int[][][] words = model.createWords(samples);
                for (int f = minF; f <= maxF; f += 2) {
                    int correct;
                    model.dict.reset();
                    final WEASEL.BagOfBigrams[] bop = new WEASEL.BagOfBigrams[samples.length];
                    final int ff = f;
                    ParallelFor.withIndex(8, new ParallelFor.Each(){

                        @Override
                        public void run(int id, AtomicInteger processed) {
                            for (int w = 0; w < model.windowLengths.length; ++w) {
                                if (w % 8 != id) continue;
                                WEASEL.BagOfBigrams[] bobForOneWindow = WEASELClassifier.this.fitOneWindow(samples, model.windowLengths, mean2, words[w], ff, w);
                                WEASELClassifier.this.mergeBobs(bop, bobForOneWindow);
                            }
                        }
                    });
                    Problem problem = WEASELClassifier.initLibLinearProblem(bop, model.dict, bias);
                    if (DEBUG) {
                        System.out.println("Train Dict Size: " + model.dict.size() + " Memory: " + this.getUsedMemory() + " MB");
                    }
                    if ((correct = WEASELClassifier.trainLibLinear(problem, solverType, c, iterations, p, folds)) > maxCorrect) {
                        maxCorrect = correct;
                        bestF = f;
                        bestNorm = mean2;
                    }
                    if (correct == samples.length) break block2;
                }
            }
            int[] windowLengths = this.getWindowLengths(samples, bestNorm);
            final WEASEL model = new WEASEL(maxF, maxS, windowLengths, bestNorm, lowerBounding);
            final WEASEL.BagOfBigrams[] bop = new WEASEL.BagOfBigrams[samples.length];
            mean2 = bestNorm;
            final int ff = bestF;
            ParallelFor.withIndex(8, new ParallelFor.Each(){

                @Override
                public void run(int id, AtomicInteger processed) {
                    for (int w = 0; w < model.windowLengths.length; ++w) {
                        if (w % 8 != id) continue;
                        int[][] words = model.createWords(samples, w);
                        WEASEL.BagOfBigrams[] bobForOneWindow = WEASELClassifier.this.fitOneWindow(samples, model.windowLengths, mean2, words, ff, w);
                        WEASELClassifier.this.mergeBobs(bop, bobForOneWindow);
                    }
                }
            });
            Problem problem = WEASELClassifier.initLibLinearProblem(bop, model.dict, bias);
            if (DEBUG) {
                System.out.println("Final Dict Size: " + model.dict.size() + " Memory: " + this.getUsedMemory() + " MB");
            }
            Model linearModel = Linear.train(problem, new Parameter(solverType, c, iterations, p));
            return new WEASELModel(bestNorm, bestF, model, linearModel, 0, 1, maxCorrect, samples.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private WEASEL.BagOfBigrams[] fitOneWindow(TimeSeries[] samples, int[] windowLengths, boolean mean, int[][] word, int f, int w) {
        WEASEL modelForWindow = new WEASEL(f, maxS, windowLengths, mean, lowerBounding);
        WEASEL.BagOfBigrams[] bopForWindow = modelForWindow.createBagOfPatterns(word, samples, w, f);
        modelForWindow.trainChiSquared(bopForWindow, chi);
        return bopForWindow;
    }

    private synchronized void mergeBobs(WEASEL.BagOfBigrams[] bop, WEASEL.BagOfBigrams[] bopForWindow) {
        for (int i = 0; i < bop.length; ++i) {
            if (bop[i] == null) {
                bop[i] = bopForWindow[i];
                continue;
            }
            bop[i].bob.putAll(bopForWindow[i].bob);
        }
    }

    protected static Problem initLibLinearProblem(WEASEL.BagOfBigrams[] bob, WEASEL.Dictionary dict, double bias) {
        Linear.resetRandom();
        Linear.disableDebugOutput();
        Problem problem = new Problem();
        problem.bias = bias;
        problem.y = WEASELClassifier.getLabels(bob);
        FeatureNode[][] features = WEASELClassifier.initLibLinear(bob, dict);
        problem.n = dict.size() + 1;
        problem.l = features.length;
        problem.x = features;
        return problem;
    }

    protected static FeatureNode[][] initLibLinear(WEASEL.BagOfBigrams[] bob, WEASEL.Dictionary dict) {
        FeatureNode[][] featuresTrain = new FeatureNode[bob.length][];
        for (int j = 0; j < bob.length; ++j) {
            WEASEL.BagOfBigrams bop = bob[j];
            ArrayList<FeatureNode> features = new ArrayList<FeatureNode>(bop.bob.size());
            for (LongIntCursor word : bop.bob) {
                if (word.value <= 0) continue;
                features.add(new FeatureNode(dict.getWordIndex(word.key), word.value));
            }
            FeatureNode[] featuresArray = features.toArray(new FeatureNode[0]);
            Arrays.parallelSort(featuresArray, new Comparator<FeatureNode>(){

                @Override
                public int compare(FeatureNode o1, FeatureNode o2) {
                    return Integer.compare(o1.index, o2.index);
                }
            });
            featuresTrain[j] = featuresArray;
        }
        return featuresTrain;
    }

    protected static double[] getLabels(WEASEL.BagOfBigrams[] bagOfPatternsTestSamples) {
        double[] labels = new double[bagOfPatternsTestSamples.length];
        for (int i = 0; i < bagOfPatternsTestSamples.length; ++i) {
            labels[i] = bagOfPatternsTestSamples[i].label;
        }
        return labels;
    }

    public WEASELModel getModel() {
        return this.model;
    }

    public void setModel(WEASELModel model) {
        this.model = model;
    }

    public static class WEASELModel
    extends Classifier.Model {
        public int features;
        public WEASEL weasel;
        public Model linearModel;

        public WEASELModel() {
        }

        public WEASELModel(boolean normed, int features, WEASEL model, Model linearModel, int testing, int testSize, int training, int trainSize) {
            super("WEASEL", testing, testSize, training, trainSize, normed, -1);
            this.features = features;
            this.weasel = model;
            this.linearModel = linearModel;
        }
    }
}

