/*
 * Decompiled with CFR 0.152.
 */
package sfa.index;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sfa.index.SortedListMap;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;

public class SFATrie
implements Serializable {
    private static final long serialVersionUID = 8983404060948074333L;
    protected SFANode root;
    protected int wordLength;
    public SFA quantization = null;
    protected int leafThreshold;
    protected int minimalDepth = -1;
    public static final int symbols = 8;
    protected boolean compressed = false;
    protected transient long ioBlockRead = 0L;
    protected transient long ioTimeSeriesRead = 0L;
    protected transient long timeSeriesRead = 0L;
    public MatchingType type = MatchingType.Subsequences;
    public double[][] timeSeries;
    public double[] means;
    public double[] stddev;
    private List<Approximation> approximations;

    public SFATrie(int l, int leafThreshold) {
        this(l, leafThreshold, new SFA(SFA.HistogramType.EQUI_FREQUENCY));
    }

    public SFATrie(int l, int leafThreshold, SFA quantization) {
        this.quantization = quantization;
        this.wordLength = l;
        this.root = new SFANode(new byte[0], this.wordLength);
        this.leafThreshold = leafThreshold;
        this.approximations = new ArrayList<Approximation>();
        this.resetIoCosts();
    }

    public void buildIndexWholeMatching(TimeSeries[] samples) {
        double[][] transformed = this.quantization.fitTransformDouble(samples, this.wordLength, 8, true);
        this.initializeWholeMatching(samples);
        for (int i = 0; i < samples.length; ++i) {
            Approximation window = new Approximation(transformed[i], this.quantization.quantizationByte(transformed[i]), i);
            this.addApproximation(window);
            this.insert(window, 0, this.root);
        }
        this.compress(true);
    }

    public void buildIndexSubsequenceMatching(TimeSeries ts, int windowLength) {
        this.quantization.fitWindowing(new TimeSeries[]{ts}, windowLength, this.wordLength, 8, true, true);
        this.initializeSubsequenceMatching(ts, windowLength);
        double[][] transformed = this.quantization.transformWindowingDouble(ts);
        for (int offset = 0; offset < transformed.length; ++offset) {
            Approximation window = new Approximation(transformed[offset], this.quantization.quantizationByte(transformed[offset]), offset);
            this.addApproximation(window);
            this.insert(window, 0, this.root);
        }
        this.compress(true);
    }

    public void buildIndex(List<Approximation[]> approximations, int minDepth) {
        this.minimalDepth = minDepth;
        for (Approximation[] w : approximations) {
            for (Approximation window : w) {
                this.addApproximation(window);
                this.insert(window, 0, this.root);
            }
        }
        this.compress(false);
    }

    private void addApproximation(Approximation approximation) {
        approximation.cacheId = this.approximations.size();
        this.approximations.add(approximation);
    }

    public Approximation getApproximation(int pos) {
        return this.approximations.get(pos);
    }

    public void printStats() {
        if (!this.compressed) {
            System.out.println("\tLeaves (not path-compressed): " + this.getLeafCount());
        } else if (this.compressed) {
            System.out.println("\tLeaves (path-compressed): " + this.getLeafCount());
        }
        System.out.println("\tHeight " + this.getHeight());
        System.out.println("\tNodes " + this.getNodeCount());
        System.out.println("\tElements " + this.getSize());
    }

    private void insert(SFANode nodeToInsert, byte[] path, int index, SFANode node, SFANode parentNode) {
        node.adaptMinMaxValues(nodeToInsert);
        if (node.type == NodeType.Internal) {
            byte key = path[index];
            SFANode childNode = node.getChild(key);
            if (childNode != null) {
                if (index + 1 < path.length) {
                    this.insert(nodeToInsert, path, index + 1, childNode, node);
                } else if (nodeToInsert.type == NodeType.Internal) {
                    for (SFANode child : nodeToInsert.children) {
                        if (child == null) continue;
                        this.insert(child, child.word, index + 1, childNode, node);
                    }
                    nodeToInsert.children = null;
                } else if (nodeToInsert.type == NodeType.Leaf) {
                    for (IntCursor ts : nodeToInsert.getApproximationIds()) {
                        this.insert(this.getApproximation(ts.value), index, node);
                    }
                    nodeToInsert.removeElements();
                }
            } else {
                node.addChild(key, nodeToInsert);
            }
        } else if (node.type == NodeType.Leaf) {
            if (nodeToInsert.type == NodeType.Internal) {
                node.type = NodeType.Internal;
                for (IntCursor ts : node.getApproximationIds()) {
                    this.insert(this.getApproximation(ts.value), index, node);
                }
                node.removeElements();
                this.insert(nodeToInsert, path, index, node, parentNode);
            } else if (nodeToInsert.type == NodeType.Leaf) {
                for (IntCursor ts : nodeToInsert.getApproximationIds()) {
                    this.insert(this.getApproximation(ts.value), index - 1, parentNode);
                }
                nodeToInsert.removeElements();
            }
        }
    }

    protected void insert(Approximation element, int index, SFANode node) {
        node.adaptMinMaxValues(element);
        byte key = element.word[index];
        SFANode childNode = node.getChild(key);
        if (childNode == null) {
            childNode = node.addChild(key, this.wordLength);
            if (this.minimalDepth - 1 > index) {
                childNode.type = NodeType.Internal;
                this.insert(element, index + 1, childNode);
            } else {
                childNode.addElement(element);
            }
            return;
        }
        if (childNode.type == NodeType.Internal) {
            this.insert(element, index + 1, childNode);
        } else if (childNode.type == NodeType.Leaf) {
            if (childNode.getSize() < this.leafThreshold) {
                childNode.addElement(element);
            } else if (index >= element.word.length - 1) {
                childNode.addElement(element);
            } else {
                childNode.type = NodeType.Internal;
                for (IntCursor ts : childNode.getApproximationIds()) {
                    this.insert(this.getApproximation(ts.value), index + 1, childNode);
                }
                this.insert(element, index + 1, childNode);
                childNode.removeElements();
            }
        }
    }

    public void mergeTrees(SFATrie tree) {
        for (SFANode node : tree.root.children) {
            if (node == null) continue;
            this.insert(node, node.getWord(), 0, this.root, this.root);
        }
        if (tree.root.getElementIds() != null && !tree.root.getElementIds().isEmpty()) {
            throw new RuntimeException("error");
        }
        tree.root = null;
        this.compressed = false;
    }

    public double calculateMean(int offset) {
        double mean = 0.0;
        for (double value : this.timeSeries[offset]) {
            mean += value;
        }
        return mean / (double)this.timeSeries[offset].length;
    }

    public double calculateStddev(int offset, double mean) {
        double var = 0.0;
        for (double value : this.timeSeries[offset]) {
            var += value * value;
        }
        double norm = 1.0 / (double)this.timeSeries[offset].length;
        double buf = norm * var - mean * mean;
        if (buf > 0.0) {
            buf = Math.sqrt(buf);
        }
        return buf;
    }

    public void initializeSubsequenceMatching(TimeSeries ts, int windowLength) {
        this.type = MatchingType.Subsequences;
        this.timeSeries = new double[1][];
        this.timeSeries[0] = ts.getData();
        int size = ts.getLength() - windowLength + 1;
        this.means = new double[size];
        this.stddev = new double[size];
        TimeSeries.calcIncrementalMeanStddev(windowLength, ts.getData(), this.means, this.stddev);
    }

    public void initializeWholeMatching(TimeSeries[] ts) {
        this.type = MatchingType.WholeSeries;
        this.timeSeries = new double[ts.length][ts[0].getLength()];
        this.means = new double[this.timeSeries.length];
        this.stddev = new double[this.timeSeries.length];
        for (int offset = 0; offset < ts.length; ++offset) {
            ts[offset].norm();
            this.timeSeries[offset] = ts[offset].getData();
            this.means[offset] = 0.0;
            this.stddev[offset] = 1.0;
        }
    }

    public void compress(boolean compact) {
        if (!this.compressed) {
            this.compress(this.root, compact);
            this.compressed = true;
        }
    }

    protected void compress(SFANode node, boolean compact) {
        this.approximations = null;
        if (node.type == NodeType.Internal) {
            SFANode previousNode = null;
            int count = 0;
            for (int i = 0; i < node.children.length; ++i) {
                SFANode currentNode = node.children[i];
                if (currentNode != null) {
                    if (currentNode.type == NodeType.Leaf) {
                        currentNode.approximationIds = null;
                        if (previousNode != null && previousNode != currentNode && previousNode.getSize() + currentNode.getSize() < this.leafThreshold) {
                            previousNode.elementIds.addAll(currentNode.getElementIds());
                            previousNode.adaptMinMaxValues(currentNode);
                            currentNode.removeElements();
                            node.children[i] = previousNode;
                        } else {
                            previousNode = currentNode;
                        }
                    } else {
                        previousNode = null;
                        this.compress(currentNode, compact);
                    }
                }
                ++count;
            }
            if (compact) {
                SFANode[] children = node.children;
                node.children = new SFANode[count];
                int a = 0;
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    node.children[a++] = children[i];
                }
            }
        }
    }

    public SFANode getLeafNode(byte[] path) {
        SFANode currentNode = this.root;
        for (byte element : path) {
            SFANode newCurrentNode;
            if (currentNode.type == NodeType.Internal) {
                this.addToBlockRead(1);
                newCurrentNode = currentNode.getChild(element);
                if (newCurrentNode == null) {
                    newCurrentNode = currentNode.getChildren().iterator().next();
                }
            } else {
                return currentNode;
            }
            currentNode = newCurrentNode;
        }
        return currentNode;
    }

    public SortedListMap<Double, Integer> search(byte[] wordQuery, TimeSeries query, int k) {
        SortedListMap<Double, Integer> result = new SortedListMap<Double, Integer>(k);
        SFANode node = this.getLeafNode(wordQuery);
        if (node != null && node.type == NodeType.Leaf) {
            this.addToIOTimeSeriesRead(1);
            this.addToTimeSeriesRead(node.getSize());
            for (IntCursor idx : node.getElementIds()) {
                double distance = SFATrie.getEuclideanDistance(this.type == MatchingType.Subsequences ? this.timeSeries[0] : this.timeSeries[idx.value], query, this.means[idx.value], this.stddev[idx.value], Double.MAX_VALUE, this.type == MatchingType.Subsequences ? idx.value : 0);
                result.put(distance, idx.value);
            }
            return result;
        }
        throw new RuntimeException("No path found!");
    }

    public int getHeight() {
        return this.root.getDepth();
    }

    public int getSize() {
        return this.root.getTotalSize();
    }

    public int getNodeCount() {
        return this.root.getNodeCount();
    }

    public long getLeafCount() {
        return this.root.getLeafCount();
    }

    public List<Integer> searchEpsilonRange(TimeSeries query, double epsilon) {
        double[] dftQuery = this.quantization.transformation.transform(query, this.wordLength);
        return this.searchEpsilonRange(dftQuery, query, epsilon);
    }

    public List<Integer> searchEpsilonRange(double[] transformedQuery, TimeSeries query, double epsilon) {
        LinkedList<SFANode> queue = new LinkedList<SFANode>();
        ArrayList<Integer> result = new ArrayList<Integer>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            double distance;
            SFANode currentNode = (SFANode)queue.removeFirst();
            if (currentNode.type == NodeType.Internal) {
                this.addToBlockRead(1);
                for (SFANode child : currentNode.getChildren()) {
                    distance = this.getLowerBoundingDistance(transformedQuery, child.minValues, child.maxValues);
                    if (!(distance <= epsilon)) continue;
                    queue.add(child);
                }
                continue;
            }
            this.addToIOTimeSeriesRead(1);
            this.addToTimeSeriesRead(currentNode.getSize());
            for (IntCursor idx : currentNode.getElementIds()) {
                double[] dArray = this.type == MatchingType.Subsequences ? this.timeSeries[0] : this.timeSeries[idx.value];
                double d = this.means[idx.value];
                double d2 = this.stddev[idx.value];
                int n = this.type == MatchingType.Subsequences ? idx.value : 0;
                distance = SFATrie.getEuclideanDistance(dArray, query, d, d2, epsilon, n);
                if (!(distance <= epsilon)) continue;
                result.add(idx.value);
            }
        }
        return result;
    }

    public SortedListMap<Double, Integer> searchNearestNeighbor(TimeSeries query, int k) {
        double[] dftQuery = this.quantization.transformation.transform(query, this.wordLength);
        return this.searchKNN(dftQuery, query, k);
    }

    public SortedListMap<Double, Integer> searchKNN(double[] dftQuery, TimeSeries query, int k) {
        TreeMap queue = new TreeMap();
        SortedListMap<Double, Integer> result = new SortedListMap<Double, Integer>(k);
        this.addToMultiMap(queue, this.root, 0.0);
        while (!queue.isEmpty()) {
            double distance;
            double kthBestDistance;
            double lbDistance = queue.firstKey();
            SFANode currentNode = (SFANode)this.removeFromMultiMap(queue, lbDistance);
            double d = kthBestDistance = result.size() < k ? Double.MAX_VALUE : result.lastKey();
            if (!(lbDistance < kthBestDistance)) break;
            if (currentNode.type == NodeType.Internal) {
                this.addToBlockRead(1);
                for (SFANode child : currentNode.getChildren()) {
                    distance = this.getLowerBoundingDistance(dftQuery, child.minValues, child.maxValues);
                    if (!(distance < kthBestDistance)) continue;
                    this.addToMultiMap(queue, child, distance);
                }
                continue;
            }
            this.addToIOTimeSeriesRead(1);
            this.addToTimeSeriesRead(currentNode.getSize());
            for (IntCursor idx : currentNode.getElementIds()) {
                kthBestDistance = result.size() < k ? Double.MAX_VALUE : result.lastKey();
                double[] dArray = this.type == MatchingType.Subsequences ? this.timeSeries[0] : this.timeSeries[idx.value];
                double d2 = this.means[idx.value];
                double d3 = this.stddev[idx.value];
                int n = this.type == MatchingType.Subsequences ? idx.value : 0;
                distance = SFATrie.getEuclideanDistance(dArray, query, d2, d3, kthBestDistance, n);
                if (!(distance <= kthBestDistance)) continue;
                result.put(distance, idx.value);
            }
        }
        return result;
    }

    protected static double getEuclideanDistance(double[] tsData, TimeSeries q, double meanTs, double stdTs, double minValue, int w) {
        stdTs = stdTs > 0.0 ? 1.0 / stdTs : 1.0;
        double distance = 0.0;
        double[] qData = q.getData();
        for (int ww = 0; ww < qData.length; ++ww) {
            double value1 = (tsData[w + ww] - meanTs) * stdTs;
            double value = qData[ww] - value1;
            if (!((distance += value * value) >= minValue)) continue;
            return Double.MAX_VALUE;
        }
        return distance;
    }

    protected double getLowerBoundingDistance(double[] dftQuery, double[] minValues, double[] maxValues) {
        double newDistance = 0.0;
        for (int i = 0; i < minValues.length; ++i) {
            if (dftQuery[i] < minValues[i]) {
                newDistance += this.getDistance(minValues[i], dftQuery[i]);
                continue;
            }
            if (!(dftQuery[i] > maxValues[i])) continue;
            newDistance += this.getDistance(maxValues[i], dftQuery[i]);
        }
        return newDistance;
    }

    protected double getDistance(double d, double sax) {
        double value = d - sax;
        return 2.0 * value * value;
    }

    public void checkIndex() {
        this.testInvariant(this.root);
    }

    protected void testInvariant(SFANode node) {
        if (node.type == NodeType.Leaf) {
            if (node.elementIds.size() == 0) {
                throw new RuntimeException("Leaf Node has no Elements!");
            }
            if (node.children != null && !node.getChildren().isEmpty()) {
                throw new RuntimeException("Leaf Node has Children!");
            }
        } else if (node.type == NodeType.Internal) {
            if (node.elementIds != null && node.elementIds.size() != 0) {
                throw new RuntimeException("Internal Node has Elements!");
            }
            if (node.children == null || node.getChildren().isEmpty()) {
                throw new RuntimeException("Internal Node has no Children!");
            }
        }
    }

    public void setMinimalDepth(int minimalHeight) {
        this.minimalDepth = minimalHeight;
    }

    public boolean equals(Object treeObject) {
        SFATrie tree = (SFATrie)treeObject;
        HashSet<SFANode> thisTree = new HashSet<SFANode>();
        HashMap<SFANode, SFANode> otherTree = new HashMap<SFANode, SFANode>();
        thisTree.add(this.root);
        otherTree.put(tree.root, tree.root);
        while (!thisTree.isEmpty() && !otherTree.isEmpty()) {
            SFANode firstNode = (SFANode)thisTree.iterator().next();
            thisTree.remove(firstNode);
            SFANode firstNode2 = (SFANode)otherTree.remove(firstNode);
            if (firstNode2 != null) {
                if (firstNode.equals(firstNode2)) {
                    for (SFANode node : firstNode.getChildren()) {
                        thisTree.add(node);
                    }
                    for (SFANode node : firstNode2.getChildren()) {
                        otherTree.put(node, node);
                    }
                    continue;
                }
                return false;
            }
            return false;
        }
        return thisTree.isEmpty() && otherTree.isEmpty();
    }

    public void resetIoCosts() {
        this.ioBlockRead = 0L;
        this.ioTimeSeriesRead = 0L;
        this.timeSeriesRead = 0L;
    }

    public void addToBlockRead(int blockCost) {
        this.ioBlockRead += (long)blockCost;
    }

    public void addToIOTimeSeriesRead(int ioCost) {
        this.ioTimeSeriesRead += (long)ioCost;
    }

    public void addToTimeSeriesRead(int timeSeries) {
        this.timeSeriesRead += (long)timeSeries;
    }

    public long getBlockRead() {
        return this.ioBlockRead;
    }

    public long getIoTimeSeriesRead() {
        return this.ioTimeSeriesRead;
    }

    public long getTimeSeriesRead() {
        return this.timeSeriesRead;
    }

    protected <E> E removeFromMultiMap(TreeMap<Double, List<E>> queue, double distance) {
        List<E> elements = queue.get(distance);
        E top = elements.remove(0);
        if (elements.size() == 0) {
            queue.remove(distance);
        }
        return top;
    }

    protected <E> void addToMultiMap(TreeMap<Double, List<E>> queue, E object, double key) {
        List<E> element = queue.get(key);
        if (element == null) {
            queue.put(key, new LinkedList());
        }
        queue.get(key).add(object);
    }

    public boolean writeToDisk(File path) {
        boolean bl;
        ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(path), 0x800000));
        try {
            out.writeObject(this);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        out.close();
        return bl;
    }

    public static SFATrie loadFromDisk(File path) {
        SFATrie sFATrie;
        ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(path)));
        try {
            sFATrie = (SFATrie)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        in.close();
        return sFATrie;
    }

    public class SFANode
    implements Serializable {
        private static final long serialVersionUID = -645698847993760867L;
        private SFANode[] children;
        private transient IntArrayList elementIds;
        private transient IntArrayList approximationIds;
        protected byte[] word;
        protected double[] minValues;
        protected double[] maxValues;
        protected NodeType type = NodeType.Leaf;

        public SFANode(byte[] word, int length) {
            this.word = word;
            this.minValues = new double[length];
            this.maxValues = new double[length];
            Arrays.fill(this.minValues, Double.MAX_VALUE);
            Arrays.fill(this.maxValues, Double.MIN_VALUE);
            this.elementIds = new IntArrayList(SFATrie.this.leafThreshold / 2);
            this.approximationIds = new IntArrayList(SFATrie.this.leafThreshold / 2);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.isLeaf()) {
                int[] elem = (int[])in.readUnshared();
                this.elementIds = new IntArrayList(elem.length);
                this.elementIds.add(elem);
            }
        }

        private void writeObject(ObjectOutputStream o) throws IOException {
            o.defaultWriteObject();
            if (this.isLeaf()) {
                o.writeUnshared(this.elementIds.toArray());
            }
        }

        public void removeElements() {
            if (this.elementIds != null) {
                this.elementIds = null;
                this.approximationIds = null;
            }
        }

        public void clear() {
            this.elementIds.clear();
            this.approximationIds.clear();
        }

        public SFANode addChild(byte key, int dimensionality) {
            byte[] newWord = Arrays.copyOf(this.word, this.word.length + 1);
            newWord[newWord.length - 1] = key;
            return this.addChild(key, new SFANode(newWord, dimensionality));
        }

        public SFANode addChild(byte key, SFANode childNode) {
            if (this.children == null) {
                this.children = new SFANode[8];
            }
            this.type = NodeType.Internal;
            this.children[key] = childNode;
            return childNode;
        }

        public SFANode getChild(byte key) {
            if (this.children != null) {
                return this.children[key];
            }
            return null;
        }

        public Collection<SFANode> getChildren() {
            if (this.children == null) {
                return new ArrayList<SFANode>();
            }
            HashSet<SFANode> uniqueNodes = new HashSet<SFANode>();
            for (SFANode nodes : this.children) {
                if (nodes == null) continue;
                uniqueNodes.add(nodes);
            }
            return uniqueNodes;
        }

        public void addElement(Approximation element) {
            if (this.type == NodeType.Internal) {
                throw new RuntimeException("Called add Time Series on internal node!");
            }
            this.elementIds.add(element.pos);
            this.approximationIds.add(element.cacheId);
            this.adaptMinMaxValues(element);
        }

        public void adaptMinMaxValues(Approximation element) {
            this.adaptMinMaxValues(element.fourierValues, element.fourierValues);
        }

        public void adaptMinMaxValues(SFANode node) {
            this.adaptMinMaxValues(node.minValues, node.maxValues);
        }

        public void adaptMinMaxValues(double[] minData, double[] maxData) {
            for (int i = 0; i < minData.length; ++i) {
                this.minValues[i] = Math.min(minData[i], this.minValues[i]);
                this.maxValues[i] = Math.max(maxData[i], this.maxValues[i]);
            }
        }

        public IntArrayList getElementIds() {
            return this.elementIds;
        }

        public IntArrayList getApproximationIds() {
            return this.approximationIds;
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            output.append(this.type + "\t");
            for (byte c : this.word) {
                output.append(c + " ");
            }
            return output.toString();
        }

        public int getDepth() {
            int height = 0;
            for (SFANode node : this.getChildren()) {
                height = Math.max(height, node.getDepth() + 1);
            }
            return height;
        }

        public long getLeafCount() {
            long leaves = 0L;
            for (SFANode node : this.getChildren()) {
                if (node.isLeaf()) {
                    ++leaves;
                    continue;
                }
                leaves += node.getLeafCount();
            }
            return leaves;
        }

        public boolean isLeaf() {
            return this.type == NodeType.Leaf;
        }

        public int getNodeCount() {
            int nodes = 0;
            for (SFANode node : this.getChildren()) {
                ++nodes;
                if (node.type != NodeType.Internal) continue;
                nodes += node.getNodeCount();
            }
            return nodes;
        }

        public int getTotalSize() {
            int size = 0;
            for (SFANode node : this.getChildren()) {
                if (node.isLeaf()) {
                    size += node.getSize();
                    continue;
                }
                size += node.getTotalSize();
            }
            return size;
        }

        public byte[] getWord() {
            return this.word;
        }

        public boolean equals(Object obj) {
            SFANode node = (SFANode)obj;
            return node != null && Arrays.equals(this.getWord(), node.getWord()) && node.type == this.type && Arrays.equals(this.maxValues, node.maxValues) && Arrays.equals(this.minValues, node.minValues) && this.getSize() == node.getSize();
        }

        public int hashCode() {
            return Arrays.hashCode(this.getWord());
        }

        public int getSize() {
            if (this.type == NodeType.Leaf) {
                return this.elementIds.size();
            }
            return this.getChildren().size();
        }
    }

    public static class Approximation
    implements Serializable {
        private static final long serialVersionUID = -6192378071620042008L;
        byte[] word;
        double[] fourierValues;
        int pos;
        transient int cacheId;

        public Approximation(double[] fourierValues, byte[] word, int pos) {
            this.word = word;
            this.pos = pos;
            this.fourierValues = fourierValues;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.word = (byte[])in.readUnshared();
            this.fourierValues = (double[])in.readUnshared();
            this.pos = in.readInt();
            this.cacheId = -1;
        }

        private void writeObject(ObjectOutputStream o) throws IOException {
            o.writeUnshared(this.word);
            o.writeUnshared(this.fourierValues);
            o.writeInt(this.pos);
        }
    }

    public static enum StorageType {
        Memory,
        Disk;

    }

    public static enum MatchingType {
        WholeSeries,
        Subsequences;

    }

    public static enum NodeType {
        Leaf,
        Internal;

    }
}

