/*
 * Decompiled with CFR 0.152.
 */
package sfa.index;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.SFAWordsTest;
import sfa.index.SFATrie;
import sfa.index.SortedListMap;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;

@RunWith(value=JUnit4.class)
public class SFATrieTest {
    static final int l = 20;
    static final int leafThreshold = 10;
    static final int k = 1;

    public static void testWholeMatching() throws IOException {
        int N = 10000;
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] timeSeries2 = TimeSeriesLoader.readSamplesQuerySeries(classLoader.getResource("datasets/indexing/query_lightcurves.txt").getFile());
        int n = timeSeries2[0].getLength();
        System.out.println("Queries: " + timeSeries2.length);
        System.out.println("Generating Time Series");
        TimeSeries[] timeSeries = new TimeSeries[N];
        for (int i = 0; i < N; ++i) {
            timeSeries[i] = TimeSeriesLoader.generateRandomWalkData(n, new Random(i));
            timeSeries[i].norm();
        }
        System.out.println("Whole Series: " + timeSeries.length);
        Runtime runtime = Runtime.getRuntime();
        long mem = runtime.totalMemory();
        SFATrie index = new SFATrie(20, 10);
        index.buildIndexWholeMatching(timeSeries);
        index.checkIndex();
        SFATrieTest.performGC();
        System.out.println("Memory: " + (runtime.totalMemory() - mem) / 0x100000L + " MB (rough estimate)");
        System.out.println("Perform NN-queries");
        for (int i = 0; i < timeSeries2.length; ++i) {
            System.out.println(i + 1 + ". Query");
            TimeSeries query = timeSeries2[i];
            long time = System.currentTimeMillis();
            SortedListMap<Double, Integer> result = index.searchNearestNeighbor(query, 1);
            time = System.currentTimeMillis() - time;
            System.out.println("\tSFATree:" + (double)time / 1000.0 + "s");
            List<Double> distances = result.keys();
            index.resetIoCosts();
            time = System.currentTimeMillis();
            double resultDistance = Double.MAX_VALUE;
            for (int w = 0; w < N; ++w) {
                double distance = SFATrieTest.getEuclideanDistance(timeSeries[w], query, 0.0, 1.0, resultDistance, 0);
                resultDistance = Math.min(distance, resultDistance);
            }
            time = System.currentTimeMillis() - time;
            System.out.println("\tEuclidean:" + (double)time / 1000.0 + "s");
            Assert.assertEquals("Distances do not match: " + resultDistance + "\t" + distances.get(0), distances.get(0), resultDistance, 0.003);
        }
        System.out.println("All ok...");
    }

    public static void testSubsequenceMatching() throws IOException {
        System.out.println("Loading Time Series");
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] timeSeries2 = TimeSeriesLoader.readSamplesQuerySeries(classLoader.getResource("datasets/indexing/query_lightcurves.txt").getFile());
        TimeSeries timeSeries = TimeSeriesLoader.generateRandomWalkData(100000, new Random(1L));
        System.out.println("Sample DS size : " + timeSeries.getLength());
        int windowLength = timeSeries2[0].getLength();
        System.out.println("Query DS size : " + windowLength);
        Runtime runtime = Runtime.getRuntime();
        long mem = runtime.totalMemory();
        long time = System.currentTimeMillis();
        SFATrie index = new SFATrie(20, 10);
        index.buildIndexSubsequenceMatching(timeSeries, windowLength);
        index.checkIndex();
        SFATrieTest.performGC();
        System.out.println("Memory: " + (runtime.totalMemory() - mem) / 0x100000L + " MB (rough estimate)");
        System.out.println("Perform NN-queries");
        int size = timeSeries.getData().length - windowLength + 1;
        double[] means = new double[size];
        double[] stds = new double[size];
        TimeSeries.calcIncrementalMeanStddev(windowLength, timeSeries.getData(), means, stds);
        for (int i = 0; i < timeSeries2.length; ++i) {
            System.out.println(i + 1 + ". Query");
            TimeSeries query = timeSeries2[i];
            time = System.currentTimeMillis();
            SortedListMap<Double, Integer> result = index.searchNearestNeighbor(query, 1);
            time = System.currentTimeMillis() - time;
            System.out.println("\tSFATree:" + (double)time / 1000.0 + "s");
            List<Double> distances = result.keys();
            index.resetIoCosts();
            time = System.currentTimeMillis();
            double resultDistance = Double.MAX_VALUE;
            for (int ww = 0; ww < size; ++ww) {
                double distance = SFATrieTest.getEuclideanDistance(timeSeries, query, means[ww], stds[ww], resultDistance, ww);
                resultDistance = Math.min(distance, resultDistance);
            }
            time = System.currentTimeMillis() - time;
            System.out.println("\tEuclidean:" + (double)time / 1000.0 + "s");
            Assert.assertEquals("Distances do not match: " + resultDistance + "\t" + distances.get(0), distances.get(0), resultDistance, 0.003);
        }
        System.out.println("All ok...");
    }

    public static void testSubsequenceMatchingRangeQuery() throws IOException {
        System.out.println("Loading Time Series");
        ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
        TimeSeries[] timeSeries2 = TimeSeriesLoader.readSamplesQuerySeries(classLoader.getResource("datasets/indexing/query_lightcurves.txt").getFile());
        TimeSeries timeSeries = TimeSeriesLoader.generateRandomWalkData(100000, new Random(1L));
        System.out.println("Sample DS size : " + timeSeries.getLength());
        int windowLength = timeSeries2[0].getLength();
        System.out.println("Query DS size : " + windowLength);
        Runtime runtime = Runtime.getRuntime();
        long mem = runtime.totalMemory();
        long time = System.currentTimeMillis();
        SFATrie index = new SFATrie(20, 10);
        index.buildIndexSubsequenceMatching(timeSeries, windowLength);
        index.checkIndex();
        SFATrieTest.performGC();
        System.out.println("Memory: " + (runtime.totalMemory() - mem) / 0x100000L + " MB (rough estimate)");
        System.out.println("Perform NN-queries");
        int size = timeSeries.getData().length - windowLength + 1;
        double[] means = new double[size];
        double[] stds = new double[size];
        TimeSeries.calcIncrementalMeanStddev(windowLength, timeSeries.getData(), means, stds);
        for (int i = 0; i < timeSeries2.length; ++i) {
            System.out.println(i + 1 + ". Query");
            TimeSeries query = timeSeries2[i];
            double epsilon = Double.MAX_VALUE;
            for (int ww = 0; ww < size; ++ww) {
                double distance = SFATrieTest.getEuclideanDistance(timeSeries, query, means[ww], stds[ww], epsilon, ww);
                if (!(distance < epsilon)) continue;
                epsilon = 1.001 * distance;
            }
            long timeED = System.currentTimeMillis();
            int count = 0;
            for (int ww = 0; ww < size; ++ww) {
                double distance = SFATrieTest.getEuclideanDistance(timeSeries, query, means[ww], stds[ww], epsilon, ww);
                if (!(distance <= epsilon)) continue;
                ++count;
            }
            timeED = System.currentTimeMillis() - timeED;
            time = System.currentTimeMillis();
            List<Integer> result = index.searchEpsilonRange(query, epsilon);
            time = System.currentTimeMillis() - time;
            System.out.println("\tSFATree:" + (double)time / 1000.0 + "s");
            index.resetIoCosts();
            for (Integer a : result) {
                System.out.println(a);
            }
            System.out.println("\tEuclidean:" + (double)timeED / 1000.0 + "s");
            Assert.assertEquals("Counts do not match: " + result.size() + "\t" + count, (double)result.size(), (double)count, 0.0);
        }
        System.out.println("All ok...");
    }

    public static void performGC() {
        try {
            System.gc();
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Assert.fail(e.getMessage());
        }
    }

    public static double getEuclideanDistance(TimeSeries ts, TimeSeries q, double meanTs, double stdTs, double minValue, int w) {
        stdTs = stdTs > 0.0 ? 1.0 / stdTs : 1.0;
        double distance = 0.0;
        double[] tsData = ts.getData();
        double[] qData = q.getData();
        for (int ww = 0; ww < qData.length; ++ww) {
            double value1 = (tsData[w + ww] - meanTs) * stdTs;
            double value = qData[ww] - value1;
            if (!((distance += value * value) > minValue)) continue;
            return Double.MAX_VALUE;
        }
        return distance;
    }

    @Test
    public void testSFATrieTest() throws IOException {
        SFATrieTest.testWholeMatching();
        SFATrieTest.testSubsequenceMatching();
        SFATrieTest.testSubsequenceMatchingRangeQuery();
    }
}

