/*
 * Decompiled with CFR 0.152.
 */
package sfa.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public class SortedListMap<K extends Comparable<K>, V> {
    private List<K> keys = new ArrayList<K>();
    private List<V> values = new ArrayList<V>();
    private int maxSize = 0;
    private static final int UNDEFINED = -1;

    public SortedListMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public SortedListMap() {
        this.maxSize = -1;
    }

    public void clear() {
        this.keys = new ArrayList<K>();
        this.values = new ArrayList<V>();
    }

    public boolean containsKey(K key) {
        return Collections.binarySearch(this.keys, key) >= 0;
    }

    public void replaceValue(K key, V value) {
        int pos = this.findFirstOccurrence(key);
        if (pos >= 0) {
            this.values.set(pos, value);
        }
    }

    private int findFirstOccurrence(K key) {
        int pos = Collections.binarySearch(this.keys, key);
        if (pos > 0) {
            while (pos > 0 && ((Comparable)this.keys.get(pos - 1)).equals(key)) {
                --pos;
            }
        }
        return pos;
    }

    private int findLastOccurrence(K key) {
        int pos = Collections.binarySearch(this.keys, key);
        if (pos > 0) {
            while (pos < this.keys.size() - 1 && ((Comparable)this.keys.get(pos + 1)).equals(key)) {
                ++pos;
            }
        }
        return pos;
    }

    public V getFirstOccurrence(K key) {
        int pos = this.findFirstOccurrence(key);
        if (pos >= 0) {
            return this.values.get(pos);
        }
        throw new NoSuchElementException("Element with " + key + " not present.");
    }

    public V getLastOccurrence(K key) {
        int pos = this.findLastOccurrence(key);
        if (pos >= 0) {
            return this.values.get(pos);
        }
        throw new NoSuchElementException("Element with " + key + " not present.");
    }

    public void put(K key, V value) {
        int pos = this.findFirstOccurrence(key);
        if (pos >= 0 && this.values.get(pos) != value) {
            this.keys.add(pos, key);
            this.values.add(pos, value);
        }
        if (pos < 0) {
            this.keys.add(-pos - 1, key);
            this.values.add(-pos - 1, value);
        }
        if (this.size() > this.maxSize && this.maxSize != -1) {
            this.keys.remove(this.keys.size() - 1);
            this.values.remove(this.values.size() - 1);
        }
    }

    public V removeFirst(K key) {
        int pos = this.findFirstOccurrence(key);
        if (pos >= 0) {
            this.keys.remove(pos);
            return this.values.remove(pos);
        }
        throw new NoSuchElementException("Element with " + key + " not present.");
    }

    public int size() {
        return this.keys.size();
    }

    public List<K> keys() {
        return this.keys;
    }

    public List<V> values() {
        return this.values;
    }

    public K firstKey() {
        return (K)((Comparable)this.keys.get(0));
    }

    public K lastKey() {
        return (K)((Comparable)this.keys.get(this.keys.size() - 1));
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }
}

