/*
 * Decompiled with CFR 0.152.
 */
package sfa.timeseries;

import java.io.Serializable;
import java.util.Arrays;

public class TimeSeries
implements Serializable {
    private static final long serialVersionUID = 6340030797230203868L;
    protected double[] data = null;
    protected double mean = 0.0;
    protected double stddev = 1.0;
    protected boolean normed = false;
    protected Double label = null;
    public static boolean APPLY_Z_NORM = true;

    public TimeSeries() {
    }

    public TimeSeries(double[] data) {
        this.data = data;
    }

    public TimeSeries(double[] data, Double label) {
        this(data);
        this.label = label;
    }

    public boolean isNormed() {
        return this.normed;
    }

    public double[] getData() {
        return this.data;
    }

    public double getData(int i) {
        return this.data[i];
    }

    public void setData(double[] init) {
        this.data = init;
    }

    public int getLength() {
        return this.data == null ? 0 : this.data.length;
    }

    public void norm() {
        this.norm(true);
    }

    public void norm(boolean normMean) {
        this.mean = this.calculateMean();
        this.stddev = this.calculateStddev();
        if (!this.isNormed()) {
            this.norm(normMean, this.mean, this.stddev);
        }
    }

    public void norm(boolean normMean, double mean, double stddev) {
        this.mean = mean;
        this.stddev = stddev;
        if (APPLY_Z_NORM && !this.isNormed()) {
            double inverseStddev;
            double d = inverseStddev = this.stddev != 0.0 ? 1.0 / this.stddev : 1.0;
            if (normMean) {
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = (this.data[i] - this.mean) * inverseStddev;
                }
                this.mean = 0.0;
            } else if (inverseStddev != 1.0) {
                int i = 0;
                while (i < this.data.length) {
                    int n = i++;
                    this.data[n] = this.data[n] * inverseStddev;
                }
            }
            this.normed = true;
        }
    }

    public double calculateStddev() {
        this.stddev = 0.0;
        double var = 0.0;
        for (double value : this.getData()) {
            var += value * value;
        }
        double norm = 1.0 / (double)this.data.length;
        double buf = norm * var - this.mean * this.mean;
        if (buf > 0.0) {
            this.stddev = Math.sqrt(buf);
        }
        return this.stddev;
    }

    public double calculateMean() {
        this.mean = 0.0;
        for (double value : this.getData()) {
            this.mean += value;
        }
        this.mean /= (double)this.data.length;
        return this.mean;
    }

    public double getStddev() {
        return this.stddev;
    }

    public double getMean() {
        return this.mean;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeSeries)) {
            throw new RuntimeException("Objects should be time series: " + o.toString());
        }
        TimeSeries ts = (TimeSeries)o;
        if (ts.isNormed() != this.isNormed()) {
            throw new RuntimeException("Please norm both time series");
        }
        if (ts.getLength() != this.getLength()) {
            return false;
        }
        for (int i = 0; i < ts.getLength(); ++i) {
            if (ts.data[i] == this.data[i]) continue;
            return false;
        }
        return true;
    }

    public TimeSeries getSubsequence(int offset, int windowSize) {
        double[] subsequenceData = Arrays.copyOfRange(this.data, offset, Math.min(this.data.length, offset + windowSize));
        TimeSeries sequence = new TimeSeries(subsequenceData, this.label);
        sequence.norm();
        return sequence;
    }

    public TimeSeries[] getSubsequences(int windowSize, boolean normMean) {
        int ws = Math.min(windowSize, this.data.length);
        int size = this.data.length - ws + 1;
        TimeSeries[] subsequences = new TimeSeries[size];
        double[] means = new double[size];
        double[] stddevs = new double[size];
        TimeSeries.calcIncrementalMeanStddev(windowSize, this.data, means, stddevs);
        for (int i = 0; i < subsequences.length; ++i) {
            double[] subsequenceData = new double[windowSize];
            System.arraycopy(this.data, i, subsequenceData, 0, ws);
            subsequences[i] = new TimeSeries(subsequenceData, this.getLabel());
            subsequences[i].norm(normMean, means[i], stddevs[i]);
        }
        return subsequences;
    }

    public static void calcIncrementalMeanStddev(int windowLength, double[] tsData, double[] means, double[] stds) {
        double sum = 0.0;
        double squareSum = 0.0;
        double rWindowLength = 1.0 / (double)windowLength;
        for (int ww = 0; ww < Math.min(tsData.length, windowLength); ++ww) {
            sum += tsData[ww];
            squareSum += tsData[ww] * tsData[ww];
        }
        means[0] = sum * rWindowLength;
        double buf = squareSum * rWindowLength - means[0] * means[0];
        stds[0] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
        int end = tsData.length - windowLength + 1;
        for (int w = 1; w < end; ++w) {
            means[w] = (sum += tsData[w + windowLength - 1] - tsData[w - 1]) * rWindowLength;
            buf = (squareSum += tsData[w + windowLength - 1] * tsData[w + windowLength - 1] - tsData[w - 1] * tsData[w - 1]) * rWindowLength - means[w] * means[w];
            stds[w] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
        }
    }

    public TimeSeries[] getDisjointSequences(int windowSize, boolean normMean) {
        int amount = this.getLength() / windowSize;
        TimeSeries[] subsequences = new TimeSeries[amount];
        for (int i = 0; i < amount; ++i) {
            double[] subsequenceData = new double[windowSize];
            System.arraycopy(this.data, i * windowSize, subsequenceData, 0, windowSize);
            subsequences[i] = new TimeSeries(subsequenceData, this.getLabel());
            subsequences[i].norm(normMean);
        }
        return subsequences;
    }

    public Double getLabel() {
        return this.label;
    }

    public void setLabel(Double label) {
        this.label = label;
    }
}

