/*
 * Decompiled with CFR 0.152.
 */
package sfa.timeseries;

import com.carrotsearch.hppc.DoubleArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;

public class TimeSeriesLoader {
    public static TimeSeries[] loadDataset(String dataset) {
        return TimeSeriesLoader.loadDataset(new File(dataset));
    }

    public static TimeSeries[] loadDataset(File dataset) {
        ArrayList<TimeSeries> samples = new ArrayList<TimeSeries>();
        try (BufferedReader br = new BufferedReader(new FileReader(dataset));){
            String line = null;
            while ((line = br.readLine()) != null) {
                String column;
                int i;
                if (line.startsWith("@")) continue;
                String separator = line.contains(",") ? "," : (line.contains("\t") ? "\t" : " ");
                String[] columns = line.split(separator);
                double[] data = new double[columns.length];
                int j = 0;
                Double label = null;
                for (i = 0; i < columns.length; ++i) {
                    column = columns[i].trim();
                    if (!TimeSeriesLoader.isNonEmptyColumn(column)) continue;
                    label = Double.valueOf(column);
                    break;
                }
                ++i;
                while (i < columns.length) {
                    column = columns[i].trim();
                    try {
                        if (TimeSeriesLoader.isNonEmptyColumn(column)) {
                            data[j++] = Double.parseDouble(column);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                    ++i;
                }
                if (j <= 0) continue;
                TimeSeries ts = new TimeSeries(Arrays.copyOfRange(data, 0, j), label);
                ts.norm();
                samples.add(ts);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done reading from " + dataset.getName() + " samples " + samples.size() + " queryLength " + ((TimeSeries)samples.get(0)).getLength());
        return samples.toArray(new TimeSeries[0]);
    }

    public static MultiVariateTimeSeries[] loadMultivariateDatsetArff(File dataset, String name, Map<String, Double> classMapping, boolean derivatives) {
        ArrayList<MultiVariateTimeSeries> samples = new ArrayList<MultiVariateTimeSeries>();
        ArrayList[] mts = null;
        long length = 0L;
        try (BufferedReader br = new BufferedReader(new FileReader(dataset));){
            String line = null;
            Double label = null;
            while ((line = br.readLine()) != null) {
                if (line.contains("@") || line.contains("%") || line.isEmpty()) continue;
                line = line.replaceAll("\\\\n", ";");
                String labelStr = line.substring(line.lastIndexOf(",") + 1, line.length());
                try {
                    label = Double.valueOf(labelStr);
                }
                catch (NumberFormatException nfe) {
                    String key = name + "_" + labelStr;
                    if (classMapping.containsKey(key)) {
                        label = classMapping.get(key);
                    }
                    label = (double)classMapping.size() + 1.0;
                    System.out.println("Novel class mapping: " + label + "<->" + labelStr);
                    classMapping.put(key, label);
                }
                line = line.substring(1, line.lastIndexOf(",") - 1);
                String[] dimensions = line.split(";");
                mts = new ArrayList[dimensions.length];
                for (int i = 0; i < mts.length; ++i) {
                    mts[i] = new ArrayList();
                }
                int id = 0;
                for (String dimension : dimensions) {
                    for (String dim : dimension.split(",")) {
                        try {
                            if (dim.equals("?")) continue;
                            double d = Double.parseDouble(dim);
                            mts[id].add(d);
                            ++length;
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                    }
                    ++id;
                }
                TimeSeriesLoader.addMTS(samples, mts, label);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done reading from " + dataset + " samples " + samples.size() + " dimensions " + ((MultiVariateTimeSeries)samples.get(0)).getDimensions());
        MultiVariateTimeSeries[] m = samples.toArray(new MultiVariateTimeSeries[0]);
        return derivatives ? TimeSeriesLoader.getDerivatives(m) : m;
    }

    public static MultiVariateTimeSeries[] loadMultivariateDatset(File dataset, boolean derivatives) throws IOException {
        ArrayList<MultiVariateTimeSeries> samples = new ArrayList<MultiVariateTimeSeries>();
        ArrayList[] mts = null;
        int lastId = -1;
        try (BufferedReader br = new BufferedReader(new FileReader(dataset));){
            String line = null;
            double label = -1.0;
            while ((line = br.readLine()) != null) {
                String[] columns = line.split(" ");
                int id = Integer.valueOf(columns[0].trim());
                if (id != lastId) {
                    TimeSeriesLoader.addMTS(samples, mts, label);
                    lastId = id;
                    mts = new ArrayList[columns.length - 3];
                    for (int i = 0; i < mts.length; ++i) {
                        mts[i] = new ArrayList();
                    }
                    label = Double.valueOf(columns[2].trim());
                }
                for (int dim = 0; dim < columns.length - 3; ++dim) {
                    String column = columns[dim + 3].trim();
                    try {
                        double d = Double.parseDouble(column);
                        mts[dim].add(d);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
            }
            TimeSeriesLoader.addMTS(samples, mts, label);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done reading from " + dataset + " samples " + samples.size() + " dimensions " + ((MultiVariateTimeSeries)samples.get(0)).getDimensions());
        MultiVariateTimeSeries[] m = samples.toArray(new MultiVariateTimeSeries[0]);
        return derivatives ? TimeSeriesLoader.getDerivatives(m) : m;
    }

    protected static MultiVariateTimeSeries[] getDerivatives(MultiVariateTimeSeries[] mtsSamples) {
        for (MultiVariateTimeSeries mts : mtsSamples) {
            TimeSeries[] deltas = new TimeSeries[2 * mts.timeSeries.length];
            TimeSeries[] samples = mts.timeSeries;
            for (int a = 0; a < samples.length; ++a) {
                TimeSeries s = samples[a];
                double[] d = new double[s.getLength()];
                for (int i = 1; i < s.getLength(); ++i) {
                    d[i - 1] = Math.abs(s.getData()[i] - s.getData()[i - 1]);
                }
                deltas[a] = samples[a];
                deltas[mts.timeSeries.length + a] = new TimeSeries(d, mts.getLabel());
            }
            mts.timeSeries = deltas;
        }
        return mtsSamples;
    }

    protected static void addMTS(List<MultiVariateTimeSeries> samples, List<Double>[] mts, double label) {
        if (mts != null && mts[0].size() > 0) {
            TimeSeries[] dimensions = new TimeSeries[mts.length];
            for (int i = 0; i < dimensions.length; ++i) {
                double[] rawdata = new double[mts[i].size()];
                int j = 0;
                for (double d : mts[i]) {
                    rawdata[j++] = d;
                }
                dimensions[i] = new TimeSeries(rawdata, label);
            }
            samples.add(new MultiVariateTimeSeries(dimensions, label));
        }
    }

    public static TimeSeries readSampleSubsequence(File dataset) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(dataset));){
            DoubleArrayList data = new DoubleArrayList();
            String line = null;
            block7: while ((line = br.readLine()) != null) {
                String[] values = (line = line.trim()).split("[ \\t]");
                if (values.length <= 0) continue;
                for (String value : values) {
                    try {
                        value = value.trim();
                        if (!TimeSeriesLoader.isNonEmptyColumn(value)) continue;
                        data.add(Double.parseDouble(value));
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            TimeSeries timeSeries = new TimeSeries(data.toArray());
            return timeSeries;
        }
    }

    public static TimeSeries[] readSamplesQuerySeries(String dataset) throws IOException {
        return TimeSeriesLoader.readSamplesQuerySeries(new File(dataset));
    }

    public static TimeSeries[] readSamplesQuerySeries(File dataset) throws IOException {
        ArrayList<TimeSeries> samples = new ArrayList<TimeSeries>();
        try (BufferedReader br = new BufferedReader(new FileReader(dataset));){
            String line = null;
            while ((line = br.readLine()) != null) {
                DoubleArrayList data = new DoubleArrayList();
                String[] values = (line = line.trim()).split("[ \\t]");
                if (values.length <= 0) continue;
                for (String value : values) {
                    try {
                        value = value.trim();
                        if (!TimeSeriesLoader.isNonEmptyColumn(value)) continue;
                        data.add(Double.parseDouble(value));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                samples.add(new TimeSeries(data.toArray()));
            }
        }
        return samples.toArray(new TimeSeries[0]);
    }

    public static boolean isNonEmptyColumn(String column) {
        return column != null && !"".equals(column) && !"NaN".equals(column) && !"\t".equals(column);
    }

    public static TimeSeries generateRandomWalkData(int maxDimension, Random generator) {
        double[] data = new double[maxDimension];
        data[0] = generator.nextGaussian();
        for (int d = 1; d < maxDimension; ++d) {
            data[d] = data[d - 1] + generator.nextGaussian();
        }
        return new TimeSeries(data);
    }
}

