/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sfa.index.SortedListMap;
import sfa.timeseries.TimeSeries;
import sfa.transformation.DWT;
import sfa.transformation.Representation;

public class APCA
extends Representation
implements Serializable {
    private static final long serialVersionUID = -5161865257245093223L;
    private transient DWT dtw = new DWT();

    @Override
    public TimeSeries transform(TimeSeries timeSeries, int n) {
        int t1Size = timeSeries.getLength();
        int m = n / 2;
        if (n > t1Size) {
            throw new IllegalArgumentException("Too many coefficients selected");
        }
        TimeSeries waveletRepresentation = this.dtw.transform(timeSeries, t1Size);
        SortedListMap<Double, Integer> firstNKoefficients = new SortedListMap<Double, Integer>(n);
        for (int i = 1; i < waveletRepresentation.getLength(); ++i) {
            int divisor = i > 1 ? (int)(Math.log(i) / Math.log(2.0)) : 0;
            double norm = Math.pow(2.0, (double)divisor / 2.0);
            firstNKoefficients.put(-Math.abs(waveletRepresentation.getData()[i] / norm), i);
        }
        double[] representation = new double[t1Size];
        while (!firstNKoefficients.isEmpty()) {
            double key = (Double)firstNKoefficients.firstKey();
            int position = (Integer)firstNKoefficients.removeFirst(key);
            representation[position] = waveletRepresentation.getData()[position];
        }
        waveletRepresentation.setData(representation);
        TimeSeries truncatedSignal = this.dtw.inverseTransform(waveletRepresentation, timeSeries.getLength());
        ArrayList<Integer> keys = new ArrayList<Integer>(3 * n);
        ArrayList<Double> values = new ArrayList<Double>(3 * n);
        double oldValue = truncatedSignal.getData()[1];
        for (int i = 1; i < truncatedSignal.getLength(); ++i) {
            double currentValue = truncatedSignal.getData()[i];
            if (oldValue == currentValue) continue;
            keys.add(i);
            values.add(oldValue);
            oldValue = currentValue;
        }
        keys.add(truncatedSignal.getLength());
        values.add(truncatedSignal.getData()[truncatedSignal.getLength() - 1]);
        int start = 0;
        int pos2 = 0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int end = (Integer)iterator.next();
            double realMean = 0.0;
            for (int i = start; i < end; ++i) {
                realMean += timeSeries.getData()[i];
            }
            values.set(pos2, realMean /= (double)(end - start));
            start = end;
            ++pos2;
        }
        while (keys.size() > m) {
            double minReconstructionError = Double.POSITIVE_INFINITY;
            int minJoinInterval = 0;
            double reconstructionErrorLeft = 0.0;
            double reconstructionErrorRight = this.calcReconstructionError(timeSeries, keys, values, 0);
            double reconstructionErrorBoth = 0.0;
            for (int pos = 0; pos < keys.size() - 1; ++pos) {
                reconstructionErrorLeft = reconstructionErrorRight;
                reconstructionErrorRight = this.calcReconstructionError(timeSeries, keys, values, pos + 1);
                reconstructionErrorBoth = this.calcJointReconstructionError(timeSeries, keys, values, pos);
                double changeOfReconstructionError = reconstructionErrorBoth - (reconstructionErrorLeft + reconstructionErrorRight);
                if (!(changeOfReconstructionError < minReconstructionError)) continue;
                minReconstructionError = changeOfReconstructionError;
                minJoinInterval = pos;
            }
            int startFirst = minJoinInterval > 0 ? (Integer)keys.get(minJoinInterval - 1) : 0;
            int endFirst = (Integer)keys.get(minJoinInterval);
            int endSecond = (Integer)keys.get(minJoinInterval + 1);
            double mean = ((double)(endFirst - startFirst) * (Double)values.get(minJoinInterval) + (double)(endSecond - endFirst) * (Double)values.get(minJoinInterval + 1)) / (double)(endSecond - startFirst);
            values.set(minJoinInterval + 1, mean);
            keys.remove(minJoinInterval);
            values.remove(minJoinInterval);
        }
        double[] apca = new double[n];
        int i = 1;
        Iterator minJoinInterval = keys.iterator();
        while (minJoinInterval.hasNext()) {
            double key;
            apca[i] = key = (double)((Integer)minJoinInterval.next()).intValue();
            i += 2;
        }
        i = 0;
        minJoinInterval = values.iterator();
        while (minJoinInterval.hasNext()) {
            double value;
            apca[i] = value = ((Double)minJoinInterval.next()).doubleValue();
            i += 2;
        }
        if (keys.size() < m) {
            for (int j = 2 * keys.size(); j < n; j += 2) {
                apca[j + 1] = truncatedSignal.getLength();
                apca[j] = truncatedSignal.getData()[truncatedSignal.getLength() - 1];
            }
        }
        if (apca[apca.length - 1] < (double)(t1Size - 1)) {
            System.err.println("Error!");
        }
        return new TimeSeries(apca);
    }

    private <E> double calcReconstructionError(TimeSeries timeSeries, List<Integer> keys, List<Double> values, int pos) {
        double reconstructionError = 0.0;
        int start = pos > 0 ? keys.get(pos - 1) : 0;
        int end = keys.get(pos);
        double mean = values.get(pos);
        for (int i = start; i < end; ++i) {
            double value = mean - timeSeries.getData()[i];
            reconstructionError += value * value;
        }
        return reconstructionError;
    }

    private <E> double calcJointReconstructionError(TimeSeries timeSeries, List<Integer> keys, List<Double> values, int index) {
        double reconstructionError = 0.0;
        int startFirst = index > 0 ? keys.get(index - 1) : 0;
        int endFirst = keys.get(index);
        int endSecond = keys.get(index + 1);
        double mean = ((double)(endFirst - startFirst) * values.get(index) + (double)(endSecond - endFirst) * values.get(index + 1)) / (double)(endSecond - startFirst);
        for (int i = startFirst; i < endSecond; ++i) {
            double value = mean - timeSeries.getData()[i];
            reconstructionError += value * value;
        }
        return reconstructionError;
    }

    @Override
    public TimeSeries inverseTransform(TimeSeries timeSeries, int n) {
        int l = timeSeries.getLength();
        double[] apca = timeSeries.getData();
        double[] data = new double[n];
        int start = 0;
        for (int i = 0; i < l; i += 2) {
            for (int j = start; j < (int)apca[i + 1]; ++j) {
                data[j] = apca[i];
            }
            start = (int)apca[i + 1];
        }
        return new TimeSeries(data);
    }

    public double getDistance(TimeSeries t1, TimeSeries query, int n, double minValue) {
        int l = t1.getLength();
        double distance = 0.0;
        double[] data = t1.getData();
        double[] data2 = query.getData();
        int offset1 = 1;
        int offset2 = 1;
        int start = 0;
        int end1 = 0;
        int end2 = 0;
        while (end1 < n || end2 < n) {
            end1 = (int)data[offset1];
            end2 = (int)data2[offset2];
            int end = Math.min(end1, end2);
            for (int j = start; j < end; ++j) {
                double value = data[offset1 - 1] - data2[offset2 - 1];
                distance += value * value;
            }
            start = end;
            if (start >= end1) {
                offset1 += 2;
            }
            if (start >= end2) {
                offset2 += 2;
            }
            if (!(distance > minValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance;
    }

    @Override
    public double getDistance(TimeSeries t1, TimeSeries query, TimeSeries originalQuery, int n, double minValue) {
        int l = t1.getLength();
        double distance = 0.0;
        double[] data = t1.getData();
        double[] data2 = originalQuery.getData();
        int start = 0;
        for (int q = 1; q < l; q += 2) {
            double end = data[q];
            double mean = 0.0;
            int i = start;
            while ((double)i < end) {
                mean += data2[i];
                ++i;
            }
            double value = data[q - 1] - (mean /= end - (double)start);
            if ((distance += value * value * (end - (double)start)) > minValue) {
                return Double.POSITIVE_INFINITY;
            }
            start = (int)end;
        }
        return distance;
    }
}

