/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.carrotsearch.hppc.IntIntHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;

public class BOSS {
    public int symbols;
    public int maxF;
    public int windowLength;
    public boolean normMean;
    public SFA signature;
    public static final int BLOCKS;

    public BOSS() {
    }

    public BOSS(int maxF, int maxS, int windowLength, boolean normMean) {
        this.maxF = maxF;
        this.symbols = maxS;
        this.windowLength = windowLength;
        this.normMean = normMean;
    }

    public int[][] createWords(final TimeSeries[] samples) {
        final int[][] words = new int[samples.length][];
        if (this.signature == null) {
            this.signature = new SFA(SFA.HistogramType.EQUI_DEPTH);
            this.signature.fitWindowing(samples, this.windowLength, this.maxF, this.symbols, this.normMean, true);
        }
        ParallelFor.withIndex(BLOCKS, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int i = 0; i < samples.length; ++i) {
                    if (i % BLOCKS != id) continue;
                    short[][] sfaWords = BOSS.this.signature.transformWindowing(samples[i]);
                    words[i] = new int[sfaWords.length];
                    for (int j = 0; j < sfaWords.length; ++j) {
                        words[i][j] = (int)Classifier.Words.createWord(sfaWords[j], BOSS.this.maxF, (byte)Classifier.Words.binlog(BOSS.this.symbols));
                    }
                }
            }
        });
        return words;
    }

    public BagOfPattern[] createBagOfPattern(int[][] words, TimeSeries[] samples, int wordLength) {
        BagOfPattern[] bagOfPatterns = new BagOfPattern[words.length];
        byte usedBits = (byte)Classifier.Words.binlog(this.symbols);
        long mask = (1L << usedBits * wordLength) - 1L;
        for (int j = 0; j < words.length; ++j) {
            bagOfPatterns[j] = new BagOfPattern(words[j].length, samples[j].getLabel());
            long lastWord = Long.MIN_VALUE;
            for (int offset = 0; offset < words[j].length; ++offset) {
                long word = (long)words[j][offset] & mask;
                if (word != lastWord) {
                    bagOfPatterns[j].bag.putOrAdd((int)word, 1, 1);
                }
                lastWord = word;
            }
        }
        return bagOfPatterns;
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        BLOCKS = runtime.availableProcessors() <= 4 ? 8 : runtime.availableProcessors();
    }

    public static class BagOfPattern {
        public IntIntHashMap bag;
        public Double label;

        public BagOfPattern() {
        }

        public BagOfPattern(int size, Double label) {
            this.bag = new IntIntHashMap(size);
            this.label = label;
        }
    }
}

