/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import org.jtransforms.fft.DoubleFFT_1D;
import sfa.timeseries.TimeSeries;
import sfa.transformation.Representation;

public class DFT
extends Representation {
    private static final long serialVersionUID = 864303984968234551L;
    public int startOffset = 2;
    private DoubleFFT_1D fft = null;
    private int localFFTSize = 0;

    @Override
    public TimeSeries transform(TimeSeries timeSeries, int l) {
        if (l % 2 == 1) {
            throw new IllegalArgumentException("warning: l should be even to store real and imaginary parts.");
        }
        int nextPowerOfTwo = this.fft != null ? this.localFFTSize : DFT.nextPowerOfTwo(timeSeries.getLength());
        double[] dataCopy2 = new double[nextPowerOfTwo];
        System.arraycopy(timeSeries.getData(), 0, dataCopy2, 0, timeSeries.getLength());
        if (this.fft == null || this.localFFTSize != nextPowerOfTwo) {
            this.fft = new DoubleFFT_1D(nextPowerOfTwo);
            this.localFFTSize = nextPowerOfTwo;
        }
        this.fft.realForward(dataCopy2);
        dataCopy2[1] = 0.0;
        double[] cutValues = new double[Math.min(l, nextPowerOfTwo - this.startOffset)];
        System.arraycopy(dataCopy2, this.startOffset, cutValues, 0, cutValues.length);
        double norm = 1.0 / Math.sqrt(nextPowerOfTwo);
        for (int i = 0; i < cutValues.length; ++i) {
            int n = i;
            cutValues[n] = cutValues[n] * norm;
            if (i % 2 != 1) continue;
            cutValues[i] = -1.0 * cutValues[i];
        }
        return new TimeSeries(cutValues);
    }

    @Override
    public TimeSeries inverseTransform(TimeSeries timeSeries, int n) {
        int nextPowerOfTwo = DFT.nextPowerOfTwo(n);
        double[] values = new double[nextPowerOfTwo];
        int l = timeSeries.getLength();
        System.arraycopy(timeSeries.getData(), 0, values, 2, l);
        double norm = Math.sqrt(nextPowerOfTwo);
        for (int i = 0; i < values.length; ++i) {
            int n2 = i;
            values[n2] = values[n2] * norm;
            if (i % 2 != 1) continue;
            values[i] = -1.0 * values[i];
        }
        this.fft.realInverse(values, false);
        return new TimeSeries(values);
    }

    protected static double magnitude(double real, double img) {
        return real * real + img * img;
    }

    @Override
    public double getDistance(TimeSeries t1, TimeSeries t2, TimeSeries originalQuery, int n, double minValue) {
        int t1Size = t1.getLength();
        double distance = 0.0;
        for (int i = 0; i < t1Size; i += 2) {
            if (!((distance += 2.0 * DFT.magnitude(t1.getData()[i] - t2.getData()[i], t1.getData()[i + 1] - t2.getData()[i + 1])) > minValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance;
    }
}

