/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import java.io.Serializable;
import library.wavelets.lift.Haar;
import sfa.timeseries.TimeSeries;
import sfa.transformation.Representation;

public class DWT
extends Representation
implements Serializable {
    private static final long serialVersionUID = -7092860432113787661L;
    static final transient Haar HAAR = new Haar();

    @Override
    public TimeSeries transform(TimeSeries timeSeries, int l) {
        int nextPowerOfTwo = DWT.nextPowerOfTwo(timeSeries.getLength());
        double[] values = new double[nextPowerOfTwo];
        System.arraycopy(timeSeries.getData(), 0, values, 0, timeSeries.getLength());
        HAAR.forwardTrans(values);
        double[] cutValues = new double[l];
        for (int i = 0; i < Math.min(l, values.length); ++i) {
            cutValues[i] = -0.5 * values[i];
        }
        return new TimeSeries(cutValues);
    }

    @Override
    public TimeSeries inverseTransform(TimeSeries timeSeries, int n) {
        int nextPowerOfTwo = DWT.nextPowerOfTwo(n);
        double[] values = new double[nextPowerOfTwo];
        System.arraycopy(timeSeries.getData(), 0, values, 0, timeSeries.getLength());
        int i = 1;
        while (i < values.length) {
            int n2 = i++;
            values[n2] = values[n2] * -2.0;
        }
        HAAR.inverseTrans(values);
        double[] originalValues = new double[n];
        System.arraycopy(values, 0, originalValues, 0, n);
        return new TimeSeries(originalValues);
    }

    @Override
    public double getDistance(TimeSeries t1, TimeSeries t2, TimeSeries originalQuery, int n, double minValue) {
        int l = t1.getLength();
        double[] differences = new double[l];
        double[] t1Values = t1.getData();
        double[] t2Values = t2.getData();
        for (int i = 0; i < l; ++i) {
            differences[i] = t1Values[i] - t2Values[i];
            differences[i] = differences[i] * differences[i];
        }
        int log2n = (int)(Math.log(Representation.closestPowerOfTwo(n)) / Math.log(2.0));
        return this.calcSiIterativ(differences, log2n, minValue);
    }

    protected double calcSiIterativ(double[] differences, int iplus1, double minValue) {
        double[] Si = new double[iplus1 + 1];
        Si[0] = differences[0];
        for (int i = 1; i <= iplus1; ++i) {
            double result = Si[i - 1];
            for (int j = (int)Math.pow(2.0, i - 1); j < (int)Math.pow(2.0, i) && j < differences.length; ++j) {
                if (!((result += differences[j]) + result > minValue)) continue;
                return Double.POSITIVE_INFINITY;
            }
            Si[i] = 2.0 * result;
        }
        return Si[iplus1];
    }
}

