/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jtransforms.fft.DoubleFFT_1D;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;

public class MFT
implements Serializable {
    private static final long serialVersionUID = 8508604292241736378L;
    private int windowSize = 0;
    private int startOffset = 0;
    private double norm = 0.0;
    private boolean normMean = false;
    private transient DoubleFFT_1D fft = null;
    private boolean useMaxOrMin = false;

    public MFT() {
    }

    public MFT(int windowSize, boolean normMean, boolean lowerBounding) {
        this(windowSize, normMean, lowerBounding, false);
    }

    public MFT(int windowSize, boolean normMean, boolean lowerBounding, boolean useMinOrMax) {
        this.windowSize = windowSize;
        this.useMaxOrMin = useMinOrMax;
        this.initFFT();
        this.startOffset = normMean ? 2 : 0;
        this.norm = lowerBounding ? 1.0 / Math.sqrt(windowSize) : 1.0;
        this.normMean = normMean;
    }

    public double[] transform(TimeSeries timeSeries, int l) {
        double[] data = new double[this.windowSize];
        System.arraycopy(timeSeries.getData(), 0, data, 0, Math.min(this.windowSize, timeSeries.getLength()));
        this.fft.realForward(data);
        data[1] = 0.0;
        double[] copy = new double[l];
        int length = Math.min(this.windowSize - this.startOffset, l);
        System.arraycopy(data, this.startOffset, copy, 0, length);
        int sign = 1;
        int i = 0;
        while (i < copy.length) {
            int n = i++;
            copy[n] = copy[n] * (this.norm * (double)sign);
            sign *= -1;
        }
        return copy;
    }

    public double[][] transformWindowing(TimeSeries timeSeries, int l) {
        int wordLength = this.useMaxOrMin ? Math.max(this.windowSize, l + this.startOffset) : Math.min(this.windowSize, l + this.startOffset);
        wordLength += wordLength % 2;
        double[] phis = new double[wordLength];
        for (int u = 0; u < phis.length; u += 2) {
            double uHalve = -u / 2;
            phis[u] = MFT.realPartEPhi(uHalve, this.windowSize);
            phis[u + 1] = MFT.complexPartEPhi(uHalve, this.windowSize);
        }
        int end = Math.max(1, timeSeries.getLength() - this.windowSize + 1);
        double[] means = new double[end];
        double[] stds = new double[end];
        TimeSeries.calcIncrementalMeanStddev(this.windowSize, timeSeries.getData(), means, stds);
        double[][] transformed = new double[end][];
        double[] mftData = new double[wordLength];
        double[] data = timeSeries.getData();
        for (int t = 0; t < end; ++t) {
            if (t > 0) {
                for (int k = 0; k < wordLength; k += 2) {
                    double real1 = mftData[k] + data[t + this.windowSize - 1] - data[t - 1];
                    double imag1 = mftData[k + 1];
                    double real = MFT.complexMultiplyRealPart(real1, imag1, phis[k], phis[k + 1]);
                    double imag = MFT.complexMultiplyImagPart(real1, imag1, phis[k], phis[k + 1]);
                    mftData[k] = real;
                    mftData[k + 1] = imag;
                }
            } else {
                double[] dft = new double[this.windowSize];
                System.arraycopy(timeSeries.getData(), 0, dft, 0, Math.min(this.windowSize, timeSeries.getLength()));
                this.fft.realForward(dft);
                dft[1] = 0.0;
                System.arraycopy(dft, 0, mftData, 0, Math.min(mftData.length, dft.length));
            }
            double[] copy = new double[l];
            System.arraycopy(mftData, this.startOffset, copy, 0, Math.min(l, mftData.length - this.startOffset));
            transformed[t] = this.normalizeFT(copy, stds[t]);
        }
        return transformed;
    }

    public short[][] transformWindowingShort(TimeSeries timeSeries, int l, SFA sfa) {
        int wordLength = this.useMaxOrMin ? Math.max(this.windowSize, l + this.startOffset) : Math.min(this.windowSize, l + this.startOffset);
        wordLength += wordLength % 2;
        double[] phis = new double[wordLength];
        for (int u = 0; u < phis.length; u += 2) {
            double uHalve = -u / 2;
            phis[u] = MFT.realPartEPhi(uHalve, this.windowSize);
            phis[u + 1] = MFT.complexPartEPhi(uHalve, this.windowSize);
        }
        int end = Math.max(1, timeSeries.getLength() - this.windowSize + 1);
        double[] means = new double[end];
        double[] stds = new double[end];
        TimeSeries.calcIncrementalMeanStddev(this.windowSize, timeSeries.getData(), means, stds);
        short[][] transformed = new short[end][];
        double[] mftData = new double[wordLength];
        double[] data = timeSeries.getData();
        double[] copy = new double[l];
        for (int t = 0; t < end; ++t) {
            if (t > 0) {
                for (int k = 0; k < wordLength; k += 2) {
                    double real1 = mftData[k] + data[t + this.windowSize - 1] - data[t - 1];
                    double imag1 = mftData[k + 1];
                    double real = MFT.complexMultiplyRealPart(real1, imag1, phis[k], phis[k + 1]);
                    double imag = MFT.complexMultiplyImagPart(real1, imag1, phis[k], phis[k + 1]);
                    mftData[k] = real;
                    mftData[k + 1] = imag;
                }
            } else {
                double[] dft = new double[this.windowSize];
                System.arraycopy(timeSeries.getData(), 0, dft, 0, Math.min(this.windowSize, timeSeries.getLength()));
                this.fft.realForward(dft);
                dft[1] = 0.0;
                System.arraycopy(dft, 0, mftData, 0, Math.min(mftData.length, dft.length));
            }
            System.arraycopy(mftData, this.startOffset, copy, 0, Math.min(l, mftData.length - this.startOffset));
            transformed[t] = sfa.quantization(this.normalizeFT(copy, stds[t]));
        }
        return transformed;
    }

    private static double complexMultiplyRealPart(double r1, double im1, double r2, double im2) {
        return r1 * r2 - im1 * im2;
    }

    private static double complexMultiplyImagPart(double r1, double im1, double r2, double im2) {
        return r1 * im2 + r2 * im1;
    }

    private static double realPartEPhi(double u, double M) {
        return Math.cos(Math.PI * 2 * u / M);
    }

    private static double complexPartEPhi(double u, double M) {
        return -Math.sin(Math.PI * 2 * u / M);
    }

    private double[] normalizeFT(double[] copy, double std) {
        double normalisingFactor = (TimeSeries.APPLY_Z_NORM && std > 0.0 ? 1.0 / std : 1.0) * this.norm;
        int sign = 1;
        int i = 0;
        while (i < copy.length) {
            int n = i++;
            copy[n] = copy[n] * ((double)sign * normalisingFactor);
            sign *= -1;
        }
        return copy;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initFFT();
    }

    private void initFFT() {
        this.fft = new DoubleFFT_1D(this.windowSize);
    }

    public static final class MFTKryoSerializer
    extends FieldSerializer<MFT> {
        public MFTKryoSerializer(Kryo kryo) {
            this(kryo, MFT.class);
        }

        public MFTKryoSerializer(Kryo kryo, Class type) {
            super(kryo, type);
        }

        @Override
        public MFT read(Kryo kryo, Input input, Class<MFT> type) {
            MFT mft = super.read(kryo, input, type);
            mft.initFFT();
            return mft;
        }
    }
}

