/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.classification.Classifier;
import sfa.classification.MUSEClassifier;
import sfa.classification.ParallelFor;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;

public class MUSE {
    public int alphabetSize;
    public int maxF;
    public SFA.HistogramType histogramType = null;
    public int[] windowLengths;
    public boolean normMean;
    public boolean lowerBounding;
    public SFA[][] signature;
    public Dictionary dict;
    public static final int BLOCKS;

    public MUSE(int maxF, int maxS, SFA.HistogramType histogramType, int[] windowLengths, boolean normMean, boolean lowerBounding) {
        this.maxF = maxF + maxF % 2;
        this.alphabetSize = maxS;
        this.windowLengths = windowLengths;
        this.normMean = normMean;
        this.lowerBounding = lowerBounding;
        this.dict = new Dictionary();
        this.signature = new SFA[windowLengths.length][];
        this.histogramType = histogramType;
    }

    public int[][][] createWords(final MultiVariateTimeSeries[] samples) {
        final int[][][] words = new int[this.windowLengths.length][samples.length][];
        ParallelFor.withIndex(BLOCKS, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int w = 0; w < MUSE.this.windowLengths.length; ++w) {
                    if (w % BLOCKS != id) continue;
                    words[w] = MUSE.this.createWords(samples, w);
                }
            }
        });
        return words;
    }

    public int[][] createWords(MultiVariateTimeSeries[] mtsSamples, int index) {
        if (this.signature[index] == null) {
            this.signature[index] = new SFA[mtsSamples[0].getDimensions()];
            for (int i = 0; i < this.signature[index].length; ++i) {
                this.signature[index][i] = new SFA(this.histogramType, false);
                this.signature[index][i].fitWindowing(mtsSamples, this.windowLengths[index], this.maxF, this.alphabetSize, this.normMean, this.lowerBounding, i);
            }
        }
        int[][] words = new int[mtsSamples.length * mtsSamples[0].getDimensions()][];
        int pos = 0;
        for (MultiVariateTimeSeries mts : mtsSamples) {
            int i = 0;
            for (TimeSeries timeSeries : mts.timeSeries) {
                words[pos] = timeSeries.getLength() >= this.windowLengths[index] ? this.signature[index][i].transformWindowingInt(timeSeries, this.maxF) : new int[0];
                ++i;
                ++pos;
            }
        }
        return words;
    }

    public BagOfBigrams[] createBagOfPatterns(int[][] wordsForWindowLength, MultiVariateTimeSeries[] samples, int w, int dimensionality, int wordLength) {
        ArrayList<BagOfBigrams> bagOfPatterns = new ArrayList<BagOfBigrams>(samples[0].getDimensions() * samples.length);
        byte usedBits = (byte)Classifier.Words.binlog(this.alphabetSize);
        int mask = (1 << usedBits * wordLength) - 1;
        int i = 0;
        int j = 0;
        while (i < samples.length) {
            BagOfBigrams bop = new BagOfBigrams(100, samples[i].getLabel());
            if (this.windowLengths[w] >= wordLength) {
                for (int dim = 0; dim < dimensionality; ++dim) {
                    for (int offset = 0; offset < wordsForWindowLength[j + dim].length; ++offset) {
                        MuseWord word = new MuseWord(w, dim, wordsForWindowLength[j + dim][offset] & mask, 0);
                        bop.bob.putOrAdd(word, 1, 1);
                        if (this.windowLengths[this.windowLengths.length - 1] >= 200 || !MUSEClassifier.BIGRAMS || offset - this.windowLengths[w] < 0) continue;
                        MuseWord bigram = new MuseWord(w, dim, wordsForWindowLength[j + dim][offset - this.windowLengths[w]] & mask, wordsForWindowLength[j + dim][offset] & mask);
                        bop.bob.putOrAdd(bigram, 1, 1);
                    }
                }
            }
            bagOfPatterns.add(bop);
            ++i;
            j += dimensionality;
        }
        return bagOfPatterns.toArray(new BagOfBigrams[0]);
    }

    public void trainChiSquared(BagOfBigrams[] bob, double chi_limit) {
        long label;
        ObjectIntHashMap<MuseWord> featureCount = new ObjectIntHashMap<MuseWord>(bob[0].bob.size());
        LongDoubleHashMap classProb = new LongDoubleHashMap(10);
        LongObjectHashMap observed = new LongObjectHashMap(bob[0].bob.size());
        for (BagOfBigrams bagOfBigrams : bob) {
            label = bagOfBigrams.label.longValue();
            if (!observed.containsKey(label)) {
                observed.put(label, new ObjectIntHashMap());
            }
            for (ObjectIntCursor<MuseWord> objectIntCursor : bagOfBigrams.bob) {
                if (objectIntCursor.value <= 0) continue;
                featureCount.putOrAdd((MuseWord)objectIntCursor.key, 1, 1);
                ((ObjectIntHashMap)observed.get(label)).putOrAdd((MuseWord)objectIntCursor.key, 1, 1);
            }
        }
        for (BagOfBigrams bagOfBigrams : bob) {
            label = bagOfBigrams.label.longValue();
            classProb.putOrAdd(label, 1.0, 1.0);
        }
        ObjectHashSet<MuseWord> chiSquare = new ObjectHashSet<MuseWord>(featureCount.size());
        for (LongDoubleCursor classLabel : classProb) {
            classLabel.value /= (double)bob.length;
            if (observed.get(classLabel.key) == null) continue;
            ObjectIntHashMap objectIntHashMap = (ObjectIntHashMap)observed.get(classLabel.key);
            for (ObjectIntCursor feature : featureCount) {
                double expected = classLabel.value * (double)feature.value;
                double chi = (double)objectIntHashMap.get((MuseWord)feature.key) - expected;
                double newChi = chi * chi / expected;
                if (!(newChi >= chi_limit) || chiSquare.contains((MuseWord)feature.key)) continue;
                chiSquare.add((MuseWord)feature.key);
            }
        }
        for (int j = 0; j < bob.length; ++j) {
            for (ObjectIntCursor<MuseWord> objectIntCursor : bob[j].bob) {
                if (chiSquare.contains((MuseWord)objectIntCursor.key)) continue;
                bob[j].bob.values[objectIntCursor.index] = 0;
            }
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        BLOCKS = runtime.availableProcessors() <= 4 ? 8 : runtime.availableProcessors();
    }

    public static class Dictionary {
        public ObjectIntHashMap<MuseWord> dictChi = new ObjectIntHashMap();
        public ArrayList<MuseWord> inverseDict = new ArrayList();

        public Dictionary() {
            this.inverseDict.add(new MuseWord(0, 0, 0, 0));
        }

        public void reset() {
            this.dictChi = new ObjectIntHashMap();
            this.inverseDict = new ArrayList();
            this.inverseDict.add(new MuseWord(0, 0, 0, 0));
        }

        public int getWordChi(MuseWord word) {
            int index = 0;
            index = this.dictChi.indexOf(word);
            if (index > -1) {
                return this.dictChi.indexGet(index);
            }
            int newWord = this.dictChi.size() + 1;
            this.dictChi.put(word, newWord);
            this.inverseDict.add(word);
            return newWord;
        }

        public int size() {
            return this.dictChi.size();
        }

        public void filterChiSquared(BagOfBigrams[] bagOfPatterns) {
            for (int j = 0; j < bagOfPatterns.length; ++j) {
                ObjectIntHashMap<MuseWord> oldMap = bagOfPatterns[j].bob;
                bagOfPatterns[j].bob = new ObjectIntHashMap();
                for (ObjectIntCursor<MuseWord> objectIntCursor : oldMap) {
                    if (!this.dictChi.containsKey((MuseWord)objectIntCursor.key) || objectIntCursor.value <= 0) continue;
                    bagOfPatterns[j].bob.put((MuseWord)objectIntCursor.key, objectIntCursor.value);
                }
            }
        }
    }

    public static class MuseWord {
        int w = 0;
        int dim = 0;
        int word = 0;
        int word2 = 0;

        public MuseWord(int w, int dim, int word, int word2) {
            this.w = w;
            this.dim = dim;
            this.word = word;
            this.word2 = word2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            MuseWord museWord = (MuseWord)o;
            return this.w == museWord.w && this.dim == museWord.dim && this.word == museWord.word && this.word2 == museWord.word2;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Integer.hashCode(this.word);
            result = 31 * result + Integer.hashCode(this.word2);
            result = 31 * result + Integer.hashCode(this.w);
            result = 31 * result + Integer.hashCode(this.dim);
            return result;
        }
    }

    public static class BagOfBigrams {
        public ObjectIntHashMap<MuseWord> bob;
        public Double label;

        public BagOfBigrams(int size, Double label) {
            this.bob = new ObjectIntHashMap(size);
            this.label = label;
        }
    }
}

