/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import sfa.timeseries.TimeSeries;
import sfa.transformation.Representation;

public class PAA
extends Representation {
    private static final long serialVersionUID = 6550901047488847653L;

    @Override
    public TimeSeries transform(TimeSeries timeSeries, int l) {
        double[] means = new double[l];
        double[] data = timeSeries.getData();
        int n = timeSeries.getLength();
        double sizeOfFrame = (double)n / (double)l;
        for (int i = 0; i < l; ++i) {
            double mean = 0.0;
            double size = 0.0;
            int s1 = (int)Math.floor(sizeOfFrame * (double)i);
            int e1 = (int)Math.min((double)timeSeries.getLength(), Math.ceil(sizeOfFrame * (double)(i + 1)));
            for (int j = s1; j < e1; ++j) {
                mean += data[j];
                size += 1.0;
            }
            means[i] = mean / (size > 0.0 ? size : 1.0);
        }
        return new TimeSeries(means);
    }

    @Override
    public TimeSeries inverseTransform(TimeSeries timeSeries, int n) {
        int l = timeSeries.getLength();
        double[] means = timeSeries.getData();
        double[] data = new double[n];
        double sizeOfFrame = (double)n / (double)l;
        for (int i = 0; i < l; ++i) {
            int j = (int)Math.ceil(sizeOfFrame * (double)i);
            while ((double)j < Math.ceil(sizeOfFrame * (double)(i + 1))) {
                data[j] = means[i];
                ++j;
            }
        }
        return new TimeSeries(data);
    }

    @Override
    public double getDistance(TimeSeries t1, TimeSeries t2, TimeSeries originalQuery, int n, double minValue) {
        int l = t1.getLength();
        double distance = 0.0;
        for (int i = 0; i < l; ++i) {
            double value = t1.getData()[i] - t2.getData()[i];
            if (!((distance += value * value) > minValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance * (double)(n / l);
    }
}

