/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import sfa.timeseries.TimeSeries;
import sfa.transformation.Representation;

public class PLA
extends Representation {
    private static final long serialVersionUID = -6323381580079336581L;

    @Override
    public TimeSeries transform(TimeSeries timeSeries, int l) {
        int n = timeSeries.getLength();
        double[] values = new double[l];
        double[] data = timeSeries.getData();
        double sizeOfFrame = (double)n / (double)(l / 2);
        int i = 0;
        while ((double)i < (double)l / 2.0) {
            double a = 0.0;
            double b = 0.0;
            double constA = (sizeOfFrame + 1.0) / 2.0;
            double constB = (2.0 * sizeOfFrame + 1.0) / 3.0;
            int t = 1;
            int j = (int)Math.ceil(sizeOfFrame * (double)i);
            while ((double)j < Math.min((double)data.length, Math.ceil(sizeOfFrame * (double)(i + 1)))) {
                a += ((double)t - constA) * data[j];
                b += ((double)t - constB) * data[j];
                ++t;
                ++j;
            }
            values[i * 2] = 12.0 * (a /= sizeOfFrame * (sizeOfFrame + 1.0) * (sizeOfFrame - 1.0));
            values[i * 2 + 1] = 6.0 * (b /= sizeOfFrame * (1.0 - sizeOfFrame));
            ++i;
        }
        return new TimeSeries(values);
    }

    @Override
    public TimeSeries inverseTransform(TimeSeries timeSeries, int n) {
        int l = timeSeries.getLength();
        double[] values = new double[n];
        double[] data = timeSeries.getData();
        double sizeOfFrame = (double)n / (double)(l / 2);
        for (int i = 0; i < l / 2; ++i) {
            int t = 1;
            for (int j = (int)Math.ceil(sizeOfFrame * (double)i); j < (int)Math.ceil(sizeOfFrame * (double)(i + 1)); ++j) {
                values[j] = data[i * 2] * (double)t + data[i * 2 + 1];
                ++t;
            }
        }
        return new TimeSeries(values);
    }

    @Override
    public double getDistance(TimeSeries t1, TimeSeries t2, TimeSeries originalQuery, int n, double minValue) {
        int l = t1.getLength();
        double distance = 0.0;
        double segments = (double)l / 2.0;
        double frameSize = (int)((double)n / segments);
        double constB = frameSize * (frameSize + 1.0);
        double constA = constB * (2.0 * frameSize + 1.0) / 6.0;
        for (int i = 0; i < l; i += 2) {
            double t2bi;
            double t3bi;
            double t1ai = t1.getData()[i];
            double t1bi = t1.getData()[i + 1];
            double t2ai = t2.getData()[i];
            double t3ai = t1ai - t2ai;
            if (!((distance += constA * t3ai * t3ai + constB * t3ai * (t3bi = t1bi - (t2bi = t2.getData()[i + 1])) + frameSize * t3bi * t3bi) > minValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance;
    }
}

