/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import sfa.timeseries.TimeSeries;

public abstract class Representation
implements Serializable {
    public void init() {
    }

    public abstract TimeSeries transform(TimeSeries var1, int var2);

    public abstract TimeSeries inverseTransform(TimeSeries var1, int var2);

    public abstract double getDistance(TimeSeries var1, TimeSeries var2, TimeSeries var3, int var4, double var5);

    public TimeSeries[] transform(TimeSeries[] samples, int l) {
        if (samples != null) {
            TimeSeries[] transform = new TimeSeries[samples.length];
            for (int i = 0; i < transform.length; ++i) {
                transform[i] = this.transform(samples[i], l);
            }
            return transform;
        }
        return null;
    }

    public static int closestPowerOfTwo(int n) {
        if ((n & n - 1) == 0) {
            return n;
        }
        return Integer.highestOneBit(n - 1) << 1;
    }

    public static int nextPowerOfTwo(int x) {
        return Representation.closestPowerOfTwo(x);
    }

    public static Representation loadFromDisk(String path) {
        Representation representation;
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
        try {
            representation = (Representation)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        in.close();
        return representation;
    }

    public boolean writeToDisk(String path) {
        boolean bl;
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path));
        try {
            out.writeObject(this);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        out.close();
        return bl;
    }
}

