/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import sfa.classification.Classifier;
import sfa.timeseries.MultiVariateTimeSeries;
import sfa.timeseries.TimeSeries;
import sfa.transformation.MFT;

public class SFA
implements Serializable {
    private static final long serialVersionUID = -3903361341617350743L;
    public transient ArrayList<ValueLabel>[] orderLine;
    public HistogramType histogramType = HistogramType.EQUI_DEPTH;
    public int alphabetSize = 256;
    public byte neededBits = (byte)Classifier.Words.binlog(this.alphabetSize);
    public int wordLength = 0;
    public boolean initialized = false;
    public boolean lowerBounding = true;
    public int maxWordLength;
    public MFT transformation;
    public double[][] bins;
    private boolean mftUseMaxOrMin = false;

    public SFA() {
    }

    public SFA(HistogramType histogramType) {
        this(histogramType, false);
    }

    public SFA(HistogramType histogramType, boolean mftUseMaxOrMin) {
        this.reset();
        this.histogramType = histogramType;
        this.mftUseMaxOrMin = mftUseMaxOrMin;
    }

    public void reset() {
        this.initialized = false;
        this.orderLine = null;
        this.bins = null;
    }

    private void init(int l, int alphabetSize) {
        this.wordLength = l;
        this.maxWordLength = l;
        this.alphabetSize = alphabetSize;
        this.initialized = true;
        this.alphabetSize = alphabetSize;
        this.neededBits = (byte)Classifier.Words.binlog(alphabetSize);
        for (double[] row : this.bins = new double[l][alphabetSize - 1]) {
            Arrays.fill(row, Double.MAX_VALUE);
        }
        this.orderLine = new ArrayList[l];
        for (int i = 0; i < this.orderLine.length; ++i) {
            this.orderLine[i] = new ArrayList();
        }
    }

    public short[] transform(TimeSeries timeSeries) {
        return this.transform(timeSeries, null);
    }

    public short[] transform(TimeSeries timeSeries, double[] approximation) {
        if (!this.initialized) {
            throw new RuntimeException("Please call fitTransform() first.");
        }
        if (approximation == null) {
            approximation = this.transformation.transform(timeSeries, this.maxWordLength);
        }
        return this.quantization(approximation);
    }

    public short[][] transform(TimeSeries[] samples) {
        if (!this.initialized) {
            throw new RuntimeException("Please call fitTransform() first.");
        }
        short[][] transform = new short[samples.length][];
        for (int i = 0; i < transform.length; ++i) {
            transform[i] = this.transform(samples[i], null);
        }
        return transform;
    }

    public short[][] transform(TimeSeries[] samples, double[][] approximation) {
        if (!this.initialized) {
            throw new RuntimeException("Please call fitTransform() first.");
        }
        short[][] transform = new short[samples.length][];
        for (int i = 0; i < transform.length; ++i) {
            transform[i] = this.transform(samples[i], approximation[i]);
        }
        return transform;
    }

    public short[] quantization(double[] approximation) {
        int i = 0;
        short[] word = new short[approximation.length];
        for (double value : approximation) {
            int c;
            for (c = 0; c < this.bins[i].length && !(value < this.bins[i][c]); c = (int)((short)(c + 1))) {
            }
            word[i++] = c;
        }
        return word;
    }

    public byte[] quantizationByte(double[] approximation) {
        int i = 0;
        byte[] word = new byte[approximation.length];
        for (double value : approximation) {
            int c;
            for (c = 0; c < this.bins[i].length && !(value < this.bins[i][c]); c = (int)((byte)(c + 1))) {
            }
            word[i++] = c;
        }
        return word;
    }

    protected void sortOrderLine() {
        for (ArrayList<ValueLabel> element : this.orderLine) {
            Collections.sort(element, new Comparator<ValueLabel>(){

                @Override
                public int compare(ValueLabel o1, ValueLabel o2) {
                    int comp = Double.compare(o1.value, o2.value);
                    if (comp != 0) {
                        return comp;
                    }
                    return Double.compare(o1.label, o2.label);
                }
            });
        }
    }

    public void fitWindowing(MultiVariateTimeSeries[] mts, int windowLength, int wordLength, int symbols, boolean normMean, boolean lowerBounding, int dim) {
        ArrayList<TimeSeries> sa = new ArrayList<TimeSeries>(mts.length * mts[0].getDimensions() * mts[0].timeSeries[0].getLength() / windowLength);
        for (MultiVariateTimeSeries timeSeries : mts) {
            sa.addAll(Arrays.asList(timeSeries.timeSeries[dim].getDisjointSequences(windowLength, normMean)));
        }
        this.fitWindowing(sa.toArray(new TimeSeries[0]), windowLength, wordLength, symbols, normMean, lowerBounding);
    }

    public void fitWindowing(TimeSeries[] timeSeries, int windowLength, int wordLength, int symbols, boolean normMean, boolean lowerBounding) {
        this.transformation = new MFT(windowLength, normMean, lowerBounding, this.mftUseMaxOrMin);
        ArrayList<TimeSeries> sa = new ArrayList<TimeSeries>(timeSeries.length * timeSeries[0].getLength() / windowLength);
        for (TimeSeries t : timeSeries) {
            sa.addAll(Arrays.asList(t.getDisjointSequences(windowLength, normMean)));
        }
        this.fitTransform(sa.toArray(new TimeSeries[0]), wordLength, symbols, normMean);
    }

    public short[][] transformWindowing(TimeSeries timeSeries) {
        return this.transformation.transformWindowingShort(timeSeries, this.maxWordLength, this);
    }

    public double[][] transformWindowingDouble(TimeSeries timeSeries) {
        return this.transformation.transformWindowing(timeSeries, this.maxWordLength);
    }

    public int[] transformWindowingInt(TimeSeries ts, int wordLength) {
        short[][] words = this.transformWindowing(ts);
        int[] intWords = new int[words.length];
        for (int i = 0; i < words.length; ++i) {
            intWords[i] = (int)Classifier.Words.createWord(words[i], wordLength, this.neededBits);
        }
        return intWords;
    }

    public double[][] fitTransformDouble(TimeSeries[] samples, int wordLength, int symbols, boolean normMean) {
        if (!this.initialized) {
            this.init(wordLength, symbols);
            if (this.transformation == null) {
                this.transformation = new MFT(samples[0].getLength(), normMean, this.lowerBounding, this.mftUseMaxOrMin);
            }
        }
        double[][] transformedSamples = this.fillOrderline(samples, wordLength);
        if (this.histogramType == HistogramType.EQUI_DEPTH) {
            this.divideEquiDepthHistogram();
        } else if (this.histogramType == HistogramType.EQUI_FREQUENCY) {
            this.divideEquiWidthHistogram();
        } else if (this.histogramType == HistogramType.INFORMATION_GAIN) {
            this.divideHistogramInformationGain();
        }
        this.orderLine = null;
        return transformedSamples;
    }

    public short[][] fitTransform(TimeSeries[] samples, int wordLength, int symbols, boolean normMean) {
        return this.transform(samples, this.fitTransformDouble(samples, wordLength, symbols, normMean));
    }

    protected double[][] fillOrderline(TimeSeries[] samples, int l) {
        double[][] transformedSamples = new double[samples.length][];
        for (int i = 0; i < samples.length; ++i) {
            transformedSamples[i] = this.transformation.transform(samples[i], l);
            for (int j = 0; j < transformedSamples[i].length; ++j) {
                double value = (double)Math.round(transformedSamples[i][j] * 100.0) / 100.0;
                this.orderLine[j].add(new ValueLabel(value, samples[i].getLabel()));
            }
        }
        this.sortOrderLine();
        return transformedSamples;
    }

    protected void divideEquiWidthHistogram() {
        int i = 0;
        for (ArrayList<ValueLabel> elements : this.orderLine) {
            if (!elements.isEmpty()) {
                double first = ((ValueLabel)elements.get((int)0)).value;
                double last = ((ValueLabel)elements.get((int)(elements.size() - 1))).value;
                double intervalWidth = (last - first) / (double)this.alphabetSize;
                for (int c = 0; c < this.alphabetSize - 1; ++c) {
                    this.bins[i][c] = intervalWidth * (double)(c + 1) + first;
                }
            }
            ++i;
        }
    }

    protected void divideEquiDepthHistogram() {
        for (int i = 0; i < this.bins.length; ++i) {
            double depth = (double)this.orderLine[i].size() / (double)this.alphabetSize;
            int pos = 0;
            long count = 0L;
            for (ValueLabel value : this.orderLine[i]) {
                long l;
                ++count;
                if (!((double)l > Math.ceil(depth * (double)(pos + 1))) || pos != 0 && this.bins[i][pos - 1] == value.value) continue;
                this.bins[i][pos++] = value.value;
            }
        }
    }

    protected void divideHistogramInformationGain() {
        for (int i = 0; i < this.orderLine.length; ++i) {
            ArrayList<ValueLabel> element = this.orderLine[i];
            if (element.isEmpty()) continue;
            ArrayList<Integer> splitPoints = new ArrayList<Integer>();
            this.findBestSplit(element, 0, element.size(), this.alphabetSize, splitPoints);
            Collections.sort(splitPoints);
            for (int j = 0; j < splitPoints.size(); ++j) {
                double value;
                this.bins[i][j] = value = ((ValueLabel)element.get((int)(splitPoints.get((int)j).intValue() + 1))).value;
            }
        }
    }

    protected static double entropy(ObjectIntHashMap<Double> frequency, double total) {
        double entropy = 0.0;
        double log2 = 1.0 / Math.log(2.0);
        for (IntCursor element : frequency.values()) {
            double p = (double)element.value / total;
            if (!(p > 0.0)) continue;
            entropy -= p * Math.log(p) * log2;
        }
        return entropy;
    }

    protected static double calculateInformationGain(ObjectIntHashMap<Double> cIn, ObjectIntHashMap<Double> cOut, double class_entropy, double total_c_in, double total) {
        double total_c_out = total - total_c_in;
        return class_entropy - total_c_in / total * SFA.entropy(cIn, total_c_in) - total_c_out / total * SFA.entropy(cOut, total_c_out);
    }

    public void findBestSplit(List<ValueLabel> element, int start, int end, int remainingSymbols, List<Integer> splitPoints) {
        double bestGain = -1.0;
        int bestPos = -1;
        int total = end - start;
        ObjectIntHashMap<Double> cIn = new ObjectIntHashMap<Double>();
        ObjectIntHashMap<Double> cOut = new ObjectIntHashMap<Double>();
        for (int pos = start; pos < end; ++pos) {
            cOut.putOrAdd(element.get((int)pos).label, 1, 1);
        }
        double class_entropy = SFA.entropy(cOut, total);
        int i = start;
        Double lastLabel = element.get((int)i).label;
        i += this.moveElement(element, cIn, cOut, start);
        for (int split = start + 1; split < end - 1; ++split) {
            Double label = element.get((int)i).label;
            i += this.moveElement(element, cIn, cOut, split);
            if (!label.equals(lastLabel)) {
                double gain = SFA.calculateInformationGain(cIn, cOut, class_entropy, i, total);
                if ((gain = (double)Math.round(gain * 1000.0) / 1000.0) >= bestGain) {
                    bestPos = split;
                    bestGain = gain;
                }
            }
            lastLabel = label;
        }
        if (bestPos > -1) {
            splitPoints.add(bestPos);
            if ((remainingSymbols /= 2) > 1) {
                if (bestPos - start > 2 && end - bestPos > 2) {
                    this.findBestSplit(element, start, bestPos, remainingSymbols, splitPoints);
                    this.findBestSplit(element, bestPos, end, remainingSymbols, splitPoints);
                } else if (end - bestPos > 4) {
                    this.findBestSplit(element, bestPos, (end - bestPos) / 2, remainingSymbols, splitPoints);
                    this.findBestSplit(element, (end - bestPos) / 2, end, remainingSymbols, splitPoints);
                } else if (bestPos - start > 4) {
                    this.findBestSplit(element, start, (bestPos - start) / 2, remainingSymbols, splitPoints);
                    this.findBestSplit(element, (bestPos - start) / 2, end, remainingSymbols, splitPoints);
                }
            }
        }
    }

    protected int moveElement(List<ValueLabel> element, ObjectIntHashMap<Double> cIn, ObjectIntHashMap<Double> cOut, int pos) {
        cIn.putOrAdd(element.get((int)pos).label, 1, 1);
        cOut.putOrAdd(element.get((int)pos).label, -1, -1);
        return 1;
    }

    public void printBins() {
        System.out.print("[");
        for (double[] element : this.bins) {
            System.out.print("-Inf\t");
            for (double element2 : element) {
                Object e = element2 != Double.MAX_VALUE ? "" + element2 : "Inf";
                System.out.print("," + (String)e + "\t");
            }
            System.out.println(";");
        }
        System.out.println("]");
    }

    public static SFA loadFromDisk(String path) {
        SFA sFA;
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
        try {
            sFA = (SFA)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        in.close();
        return sFA;
    }

    public boolean writeToDisk(String path) {
        boolean bl;
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path));
        try {
            out.writeObject(this);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        out.close();
        return bl;
    }

    public static class ValueLabel
    implements Serializable {
        private static final long serialVersionUID = 4392333771929261697L;
        public double value;
        public double label;

        public ValueLabel() {
        }

        public ValueLabel(double key, Double label) {
            this.value = key;
            this.label = label != null ? label : 0.0;
        }

        public String toString() {
            return this.value + ":" + this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            ValueLabel that = (ValueLabel)o;
            return Double.compare(that.value, this.value) == 0 && Double.compare(that.label, this.label) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.label);
        }
    }

    public static enum HistogramType {
        EQUI_FREQUENCY,
        EQUI_DEPTH,
        INFORMATION_GAIN;

    }
}

