/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import sfa.transformation.SFA;

public class SFADistance {
    private SFA sfa;

    public SFADistance(SFA transform) {
        this.sfa = transform;
    }

    public double getDistance(short[] wordsTs, short[] wordsQuery, double[] dftQuery, boolean normed, double minValue) {
        double distance = 0.0;
        int i = 0;
        if (!normed) {
            distance = this.dist(wordsTs[0], wordsQuery[0], dftQuery[0], 0);
            distance *= distance;
            i += 2;
        }
        while (i < wordsTs.length) {
            double value = this.dist(wordsTs[i], wordsQuery[i], dftQuery[i], i);
            if ((distance += 2.0 * value * value) > minValue) {
                return distance;
            }
            ++i;
        }
        return distance;
    }

    public double dist(short c1Value, short c2Value, double realC2, int dim) {
        if (c1Value == c2Value) {
            return 0.0;
        }
        return c1Value > c2Value ? this.sfa.bins[dim][c1Value - 1] - realC2 : realC2 - this.sfa.bins[dim][c1Value];
    }
}

