/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.LongLongHashMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import com.carrotsearch.hppc.cursors.LongLongCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;

public class SFASupervised
extends SFA {
    private static final long serialVersionUID = -6435016083374045799L;
    public int[] bestValues;

    public SFASupervised(SFA.HistogramType histType) {
        super(histType);
        this.lowerBounding = false;
    }

    public SFASupervised() {
        super(SFA.HistogramType.INFORMATION_GAIN);
        this.lowerBounding = false;
    }

    @Override
    public short[] quantization(double[] approximation) {
        short[] signal = new short[Math.min(approximation.length, this.bestValues.length)];
        for (int a = 0; a < signal.length; ++a) {
            int i = this.bestValues[a];
            int beta = 0;
            for (beta = 0; beta < this.bins[i].length && !(approximation[i] < this.bins[i][beta]); beta = (int)((short)(beta + 1))) {
            }
            signal[a] = beta;
        }
        return signal;
    }

    @Override
    public short[][] fitTransform(TimeSeries[] samples, int wordLength, int symbols, boolean normMean) {
        int length = this.getMaxLength(samples);
        double[][] transformedSignal = this.fitTransformDouble(samples, length, symbols, normMean);
        Indices<Double>[] best = SFASupervised.calcBestCoefficients(samples, transformedSignal);
        this.bestValues = new int[Math.min(best.length, wordLength)];
        this.maxWordLength = 0;
        for (int i = 0; i < this.bestValues.length; ++i) {
            this.bestValues[i] = best[i].index;
            this.maxWordLength = Math.max(best[i].index + 1, this.maxWordLength);
        }
        this.maxWordLength += this.maxWordLength % 2;
        return this.transform(samples, transformedSignal);
    }

    protected int getMaxLength(TimeSeries[] samples) {
        int length = 0;
        for (int i = 0; i < samples.length; ++i) {
            length = Math.max(samples[i].getLength(), length);
        }
        return length;
    }

    public static Indices<Double>[] calcBestCoefficients(TimeSeries[] samples, double[][] transformedSignal) {
        HashMap<Double, ArrayList<double[]>> classes = new HashMap<Double, ArrayList<double[]>>();
        for (int i = 0; i < samples.length; ++i) {
            ArrayList<double[]> allTs = (ArrayList<double[]>)classes.get(samples[i].getLabel());
            if (allTs == null) {
                allTs = new ArrayList<double[]>();
                classes.put(samples[i].getLabel(), allTs);
            }
            allTs.add(transformedSignal[i]);
        }
        double nSamples = transformedSignal.length;
        double nClasses = classes.keySet().size();
        int length = transformedSignal != null && transformedSignal.length > 0 ? transformedSignal[0].length : 0;
        double[] f = SFASupervised.getFoneway(length, classes, nSamples, nClasses);
        ArrayList<Indices<Double>> best = new ArrayList<Indices<Double>>(f.length);
        for (int i = 0; i < f.length; ++i) {
            if (Double.isNaN(f[i])) continue;
            best.add(new Indices<Double>(i, f[i]));
        }
        Collections.sort(best);
        return best.toArray(new Indices[0]);
    }

    public static double[] getFoneway(int length, Map<Double, ArrayList<double[]>> classes, double nSamples, double nClasses) {
        int i;
        Object sums;
        double[] ss_alldata = new double[length];
        HashMap<Double, Object> sums_args = new HashMap<Double, Object>();
        for (Map.Entry<Double, ArrayList<double[]>> allTs : classes.entrySet()) {
            sums = new double[ss_alldata.length];
            sums_args.put(allTs.getKey(), sums);
            for (double[] ts : allTs.getValue()) {
                for (i = 0; i < ts.length; ++i) {
                    int n = i;
                    ss_alldata[n] = ss_alldata[n] + ts[i] * ts[i];
                    Object object = sums;
                    int n2 = i;
                    object[n2] = object[n2] + ts[i];
                }
            }
        }
        double[] square_of_sums_alldata = new double[ss_alldata.length];
        HashMap<Double, double[]> square_of_sums_args = new HashMap<Double, double[]>();
        sums = sums_args.entrySet().iterator();
        while (sums.hasNext()) {
            Map.Entry sums2 = (Map.Entry)sums.next();
            for (int i2 = 0; i2 < ((double[])sums2.getValue()).length; ++i2) {
                int n = i2;
                square_of_sums_alldata[n] = square_of_sums_alldata[n] + ((double[])sums2.getValue())[i2];
            }
            double[] squares = new double[((double[])sums2.getValue()).length];
            square_of_sums_args.put((Double)sums2.getKey(), squares);
            for (i = 0; i < ((double[])sums2.getValue()).length; ++i) {
                int n = i;
                squares[n] = squares[n] + ((double[])sums2.getValue())[i] * ((double[])sums2.getValue())[i];
            }
        }
        for (int i3 = 0; i3 < square_of_sums_alldata.length; ++i3) {
            int n = i3;
            square_of_sums_alldata[n] = square_of_sums_alldata[n] * square_of_sums_alldata[i3];
        }
        double[] sstot = new double[ss_alldata.length];
        for (int i4 = 0; i4 < sstot.length; ++i4) {
            sstot[i4] = ss_alldata[i4] - square_of_sums_alldata[i4] / nSamples;
        }
        double[] ssbn = new double[ss_alldata.length];
        double[] sswn = new double[ss_alldata.length];
        for (Map.Entry sums3 : square_of_sums_args.entrySet()) {
            double n_samples_per_class = classes.get(sums3.getKey()).size();
            for (int i5 = 0; i5 < ((double[])sums3.getValue()).length; ++i5) {
                int n = i5;
                ssbn[n] = ssbn[n] + ((double[])sums3.getValue())[i5] / n_samples_per_class;
            }
        }
        for (int i6 = 0; i6 < square_of_sums_alldata.length; ++i6) {
            int n = i6;
            ssbn[n] = ssbn[n] - square_of_sums_alldata[i6] / nSamples;
        }
        double dfbn = nClasses - 1.0;
        double dfwn = nSamples - nClasses;
        double[] msb = new double[ss_alldata.length];
        double[] msw = new double[ss_alldata.length];
        double[] f = new double[ss_alldata.length];
        for (int i7 = 0; i7 < sswn.length; ++i7) {
            sswn[i7] = sstot[i7] - ssbn[i7];
            msb[i7] = ssbn[i7] / dfbn;
            msw[i7] = sswn[i7] / dfwn;
            f[i7] = msb[i7] / msw[i7];
        }
        return f;
    }

    public static LongDoubleHashMap getFonewaySparse(Map<Double, List<LongIntHashMap>> classes, double nSamples, double nClasses) {
        LongLongHashMap ss_alldata = new LongLongHashMap();
        HashMap<Double, Iterator<LongLongCursor>> sums_args = new HashMap<Double, Iterator<LongLongCursor>>();
        for (Map.Entry<Double, List<LongIntHashMap>> allTs : classes.entrySet()) {
            Iterator<LongLongCursor> sums = new LongLongHashMap();
            sums_args.put(allTs.getKey(), sums);
            for (LongIntHashMap longIntHashMap : allTs.getValue()) {
                for (Object cursor : longIntHashMap) {
                    long key = ((LongIntCursor)cursor).key;
                    long value = ((LongIntCursor)cursor).value;
                    ss_alldata.putOrAdd(key, value * value, value * value);
                    ((LongLongHashMap)((Object)sums)).putOrAdd(key, value, value);
                }
            }
        }
        LongLongHashMap square_of_sums_alldata = new LongLongHashMap();
        HashMap<Double, LongLongHashMap> square_of_sums_args = new HashMap<Double, LongLongHashMap>();
        for (Map.Entry entry : sums_args.entrySet()) {
            for (Iterator<Object> cursor : (LongLongHashMap)entry.getValue()) {
                square_of_sums_alldata.putOrAdd(((LongLongCursor)((Object)cursor)).key, ((LongLongCursor)((Object)cursor)).value, ((LongLongCursor)((Object)cursor)).value);
            }
            LongLongHashMap longLongHashMap = new LongLongHashMap();
            square_of_sums_args.put((Double)entry.getKey(), longLongHashMap);
            for (Object cursor : (LongLongHashMap)entry.getValue()) {
                longLongHashMap.put(((LongLongCursor)cursor).key, ((LongLongCursor)cursor).value * ((LongLongCursor)cursor).value);
            }
        }
        for (LongLongCursor longLongCursor : square_of_sums_alldata) {
            square_of_sums_alldata.put(longLongCursor.key, longLongCursor.value * longLongCursor.value);
        }
        LongDoubleHashMap sstot = new LongDoubleHashMap(ss_alldata.size());
        for (LongLongCursor longLongCursor : ss_alldata) {
            sstot.put(longLongCursor.key, (double)longLongCursor.value - (double)square_of_sums_alldata.get(longLongCursor.key) / nSamples);
        }
        LongDoubleHashMap longDoubleHashMap = new LongDoubleHashMap(ss_alldata.size());
        LongDoubleHashMap longDoubleHashMap2 = new LongDoubleHashMap(ss_alldata.size());
        for (Map.Entry sums : square_of_sums_args.entrySet()) {
            double n_samples_per_class = classes.get(sums.getKey()).size();
            for (LongLongCursor cursor : (LongLongHashMap)sums.getValue()) {
                double value = (double)cursor.value / n_samples_per_class;
                longDoubleHashMap.putOrAdd(cursor.key, value, value);
            }
        }
        for (Object cursor : square_of_sums_alldata) {
            double value = (double)(-((LongLongCursor)cursor).value) / nSamples;
            longDoubleHashMap.putOrAdd(((LongLongCursor)cursor).key, value, value);
        }
        double dfbn = nClasses - 1.0;
        double dfwn = nSamples - nClasses;
        LongDoubleHashMap msb = new LongDoubleHashMap(ss_alldata.size());
        LongDoubleHashMap msw = new LongDoubleHashMap(ss_alldata.size());
        LongDoubleHashMap f = new LongDoubleHashMap(ss_alldata.size());
        for (LongDoubleCursor cursor : sstot) {
            longDoubleHashMap2.put(cursor.key, cursor.value - longDoubleHashMap.get(cursor.key));
        }
        for (LongDoubleCursor cursor : longDoubleHashMap) {
            msb.put(cursor.key, cursor.value / dfbn);
        }
        for (LongDoubleCursor cursor : longDoubleHashMap2) {
            msw.put(cursor.key, cursor.value / dfwn);
        }
        for (LongDoubleCursor cursor : msw) {
            double value = cursor.value != 0.0 ? msb.get(cursor.key) / cursor.value : 0.0;
            f.put(cursor.key, value);
        }
        return f;
    }

    static class Indices<E extends Comparable<E>>
    implements Comparable<Indices<E>> {
        int index;
        E value;

        public Indices(int index, E value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(Indices<E> o) {
            return o.value.compareTo(this.value);
        }

        public String toString() {
            return "(" + this.index + ":" + this.value + ")";
        }
    }
}

