/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import sfa.SFAWordsTest;
import sfa.classification.ParallelFor;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.APCA;
import sfa.transformation.DFT;
import sfa.transformation.DWT;
import sfa.transformation.PAA;
import sfa.transformation.PLA;
import sfa.transformation.Representation;

public class TightnessOfLowerBounds {
    public static int startCoeff = 8;
    public static int endCoeff = 256;
    public static int tslength = 256;
    public static final int count = 1000;
    public static int finalCoeff = (int)((Math.log(endCoeff) - Math.log(startCoeff)) / Math.log(2.0)) + 1;
    static Representation[] representations = new Representation[]{new APCA(), new DFT(), new DWT(), new PAA(), new PLA()};
    static String[] datasets = new String[]{"steamgen.dat", "PostureCentroidB", "winding.dat", "ann_gun_CentroidA", "power_data.dat"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        try {
            System.out.println("Start coefficients: " + startCoeff);
            System.out.println("End coefficients: " + endCoeff);
            System.out.println("tslength: " + tslength);
            ClassLoader classLoader = SFAWordsTest.class.getClassLoader();
            File dir = new File(classLoader.getResource("datasets/indexing/").getFile());
            final double[][][] tightnessOfLowerBounds = new double[datasets.length][representations.length][finalCoeff];
            for (int d = 0; d < datasets.length; ++d) {
                final int dataD = d;
                System.out.println("\n" + datasets[d]);
                List<TimeSeries> samples = Arrays.asList(TimeSeriesLoader.readSampleSubsequence(new File(dir.getAbsolutePath() + "/" + datasets[d])).getSubsequences(tslength, true));
                System.out.println("Samples " + samples.size());
                if (samples.size() <= 2000) continue;
                final TimeSeries[] samples1 = samples.subList(0, 1000).toArray(new TimeSeries[0]);
                final TimeSeries[] samples2 = samples.subList(1000, 2000).toArray(new TimeSeries[0]);
                final double[] trueDist = new double[samples1.length];
                for (int q = 0; q < samples1.length; ++q) {
                    trueDist[q] = TightnessOfLowerBounds.getEuclideanDistance(samples1[q], samples2[q]);
                }
                ParallelFor.withIndex(representations.length, new ParallelFor.Each(){

                    @Override
                    public void run(int id, AtomicInteger processed) {
                        for (int i = 0; i < representations.length; ++i) {
                            if (id != i) continue;
                            Representation representation = representations[i];
                            int c = startCoeff;
                            int aa = 0;
                            while (c <= endCoeff) {
                                TimeSeries[][] transformedSamples = new TimeSeries[2][samples1.length];
                                for (int a = 0; a < samples1.length; ++a) {
                                    transformedSamples[0][a] = representation.transform(samples1[a], c);
                                    transformedSamples[1][a] = representation.transform(samples2[a], c);
                                }
                                for (int q = 0; q < samples1.length; ++q) {
                                    double dist = representation.getDistance(transformedSamples[0][q], transformedSamples[1][q], samples2[q], tslength, Double.MAX_VALUE);
                                    if (trueDist[q] > 1.0E-4) {
                                        double value = dist / trueDist[q];
                                        if (!Double.isNaN(value)) {
                                            double[] dArray = tightnessOfLowerBounds[dataD][i];
                                            int n = aa;
                                            dArray[n] = dArray[n] + value;
                                        }
                                    } else {
                                        double[] dArray = tightnessOfLowerBounds[dataD][i];
                                        int n = aa;
                                        dArray[n] = dArray[n] + 1.0;
                                    }
                                    if (!(dist - trueDist[q] > 1.0E-4)) continue;
                                    System.out.println("Error: " + representation.getClass().getSimpleName() + " distance " + dist + " is larger than true dist:" + trueDist[q]);
                                }
                                c *= 2;
                                ++aa;
                            }
                        }
                    }
                });
                System.out.println("");
                System.out.println("\tTightness of Lower Bounds: ");
                System.out.print("l");
                for (int i = 0; i < representations.length; ++i) {
                    Representation signature = representations[i];
                    System.out.print("\t" + signature.getClass().getSimpleName());
                }
                System.out.println();
                int c = startCoeff;
                int a = 0;
                while (c <= endCoeff) {
                    System.out.print(c);
                    for (int i = 0; i < representations.length; ++i) {
                        System.out.print("\t" + (double)Math.round(1000.0 * tightnessOfLowerBounds[d][i][a] / 1000.0) / 1000.0);
                    }
                    System.out.println("");
                    c *= 2;
                    ++a;
                }
            }
            System.out.println("");
            System.out.println("Total Averages");
            System.out.println("");
            TightnessOfLowerBounds.getTightness(tightnessOfLowerBounds);
        }
        finally {
            ParallelFor.shutdown();
        }
    }

    public static double getEuclideanDistance(TimeSeries t1, TimeSeries t2) {
        int sizeT1 = t1.getLength();
        double distance = 0.0;
        double[] t1Values = t1.getData();
        double[] t2Values = t2.getData();
        for (int i = 0; i < Math.min(sizeT1, t2.getLength()); ++i) {
            double value = t1Values[i] - t2Values[i];
            distance += value * value;
        }
        return distance;
    }

    private static void getTightness(double[][][] tightnessOfLowerBounds) {
        int i;
        double[][] avgTightnessOfLowerBounds = new double[tightnessOfLowerBounds[0].length][tightnessOfLowerBounds[0][0].length];
        for (double[][] tightnessOfLowerBound : tightnessOfLowerBounds) {
            for (int i2 = 0; i2 < tightnessOfLowerBounds[0].length; ++i2) {
                for (int c = 0; c < tightnessOfLowerBounds[0][0].length; ++c) {
                    double[] dArray = avgTightnessOfLowerBounds[i2];
                    int n = c;
                    dArray[n] = dArray[n] + tightnessOfLowerBound[i2][c] / 1000.0;
                }
            }
        }
        System.out.print("l");
        for (i = 0; i < representations.length; ++i) {
            System.out.print("\t" + representations[i].getClass().getSimpleName());
        }
        System.out.println();
        int c = startCoeff;
        int a = 0;
        while (c <= endCoeff) {
            System.out.print(c);
            for (int i3 = 0; i3 < representations.length; ++i3) {
                System.out.print("\t" + (double)Math.round(1000.0 * avgTightnessOfLowerBounds[i3][a] / (double)tightnessOfLowerBounds.length) / 1000.0);
            }
            System.out.println("");
            c *= 2;
            ++a;
        }
        System.out.println("");
        System.out.println("Highest TLB per dataset");
        System.out.println("");
        System.out.print("ds");
        for (i = 0; i < representations.length; ++i) {
            System.out.print("\t" + representations[i].getClass().getSimpleName());
        }
        System.out.println();
        for (c = 0; c < datasets.length; ++c) {
            System.out.print(datasets[c]);
            for (int i4 = 0; i4 < representations.length; ++i4) {
                System.out.print("\t" + (double)Math.round(1000.0 * tightnessOfLowerBounds[c][i4][finalCoeff - 1] / 1000.0) / 1000.0);
            }
            System.out.println("");
        }
    }
}

