/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import com.carrotsearch.hppc.DoubleIntHashMap;
import com.carrotsearch.hppc.DoubleObjectHashMap;
import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.cursors.DoubleIntCursor;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import sfa.classification.Classifier;
import sfa.classification.ParallelFor;
import sfa.classification.WEASELClassifier;
import sfa.timeseries.TimeSeries;
import sfa.transformation.SFA;
import sfa.transformation.SFASupervised;

public class WEASEL {
    public static int WORD_LIMIT = 1000;
    public int alphabetSize;
    public int maxF;
    public int[] windowLengths;
    public boolean normMean;
    public boolean lowerBounding;
    public SFA[] signature;
    public Dictionary dict;
    public static final int BLOCKS;

    public WEASEL() {
    }

    public WEASEL(int maxF, int maxS, int[] windowLengths, boolean normMean, boolean lowerBounding) {
        this.maxF = maxF;
        this.alphabetSize = maxS;
        this.windowLengths = windowLengths;
        this.normMean = normMean;
        this.lowerBounding = lowerBounding;
        this.dict = new Dictionary();
        this.signature = new SFA[windowLengths.length];
    }

    public int[][][] createWords(final TimeSeries[] samples) {
        final int[][][] words = new int[this.windowLengths.length][samples.length][];
        int processed = ParallelFor.withIndex(BLOCKS, new ParallelFor.Each(){

            @Override
            public void run(int id, AtomicInteger processed) {
                for (int w = 0; w < WEASEL.this.windowLengths.length; ++w) {
                    if (w % BLOCKS != id) continue;
                    words[w] = WEASEL.this.createWords(samples, w);
                    processed.incrementAndGet();
                }
            }
        });
        if (processed < this.windowLengths.length) {
            System.err.println("Processed: " + processed + " < " + this.windowLengths.length + " windowlengths.");
        }
        return words;
    }

    public int[][] createWords(TimeSeries[] samples, int index) {
        if (this.signature[index] == null) {
            this.signature[index] = new SFASupervised();
            this.signature[index].fitWindowing(samples, this.windowLengths[index], this.maxF, this.alphabetSize, this.normMean, this.lowerBounding);
        }
        int[][] words = new int[samples.length][];
        for (int i = 0; i < samples.length; ++i) {
            words[i] = samples[i].getLength() >= this.windowLengths[index] ? this.signature[index].transformWindowingInt(samples[i], this.maxF) : new int[0];
        }
        return words;
    }

    public BagOfBigrams[] createBagOfPatterns(int[][] wordsForWindowLength, TimeSeries[] samples, int w, int wordLength) {
        BagOfBigrams[] bagOfPatterns = new BagOfBigrams[samples.length];
        byte usedBits = (byte)Classifier.Words.binlog(this.alphabetSize);
        long mask = (1L << usedBits * wordLength) - 1L;
        int highestBit = Classifier.Words.binlog(Integer.highestOneBit(WEASELClassifier.MAX_WINDOW_LENGTH)) + 1;
        for (int j = 0; j < samples.length; ++j) {
            bagOfPatterns[j] = new BagOfBigrams(wordsForWindowLength[j].length * 2, samples[j].getLabel());
            for (int offset = 0; offset < wordsForWindowLength[j].length; ++offset) {
                long prevWord;
                long word = ((long)wordsForWindowLength[j][offset] & mask) << highestBit | (long)w;
                bagOfPatterns[j].bob.putOrAdd(word, 1, 1);
                if (offset - this.windowLengths[w] < 0 || (prevWord = (long)wordsForWindowLength[j][offset - this.windowLengths[w]] & mask) == 0L) continue;
                long newWord = prevWord << 32 | word;
                bagOfPatterns[j].bob.putOrAdd(newWord, 1, 1);
            }
        }
        return bagOfPatterns;
    }

    public BagOfBigrams[] createBagOfPatterns(int[][][] words, TimeSeries[] samples, int wordLength) {
        BagOfBigrams[] bagOfPatterns = new BagOfBigrams[samples.length];
        byte usedBits = (byte)Classifier.Words.binlog(this.alphabetSize);
        long mask = (1L << usedBits * wordLength) - 1L;
        int highestBit = Classifier.Words.binlog(Integer.highestOneBit(WEASELClassifier.MAX_WINDOW_LENGTH)) + 1;
        for (int j = 0; j < samples.length; ++j) {
            bagOfPatterns[j] = new BagOfBigrams(words[0][j].length * 2, samples[j].getLabel());
            for (int w = 0; w < this.windowLengths.length; ++w) {
                for (int offset = 0; offset < words[w][j].length; ++offset) {
                    long prevWord;
                    long word = ((long)words[w][j][offset] & mask) << highestBit | (long)w;
                    bagOfPatterns[j].bob.putOrAdd(word, 1, 1);
                    if (offset - this.windowLengths[w] < 0 || (prevWord = (long)words[w][j][offset - this.windowLengths[w]] & mask) == 0L) continue;
                    long newWord = prevWord << 32 | word;
                    bagOfPatterns[j].bob.putOrAdd(newWord, 1, 1);
                }
            }
        }
        return bagOfPatterns;
    }

    public LongHashSet trainChiSquared(BagOfBigrams[] bob, double chi_limit) {
        long label;
        LongIntHashMap featureCount = new LongIntHashMap(bob[0].bob.size());
        DoubleIntHashMap classProb = new DoubleIntHashMap(10);
        DoubleObjectHashMap<LongIntHashMap> observed = new DoubleObjectHashMap<LongIntHashMap>();
        for (BagOfBigrams bagOfPattern : bob) {
            label = bagOfPattern.label.longValue();
            int index = -1;
            LongIntHashMap obs = null;
            index = observed.indexOf(label);
            if (index > -1) {
                obs = (LongIntHashMap)observed.indexGet(index);
            } else {
                obs = new LongIntHashMap();
                observed.put(label, obs);
            }
            for (LongIntCursor word : bagOfPattern.bob) {
                if (word.value <= 0) continue;
                featureCount.putOrAdd(word.key, 1, 1);
                obs.putOrAdd(word.key, 1, 1);
            }
        }
        for (BagOfBigrams bagOfPattern : bob) {
            label = bagOfPattern.label.longValue();
            classProb.putOrAdd(label, 1, 1);
        }
        LongHashSet chiSquare = new LongHashSet(featureCount.size());
        ArrayList<PValueKey> values = new ArrayList<PValueKey>(featureCount.size());
        for (DoubleIntCursor prob : classProb) {
            double p = (double)prob.value / (double)bob.length;
            LongIntHashMap obs = (LongIntHashMap)observed.get(prob.key);
            for (LongIntCursor feature : featureCount) {
                double expected = p * (double)feature.value;
                double chi = (double)obs.get(feature.key) - expected;
                double newChi = chi * chi / expected;
                if (!(newChi >= chi_limit) || chiSquare.contains(feature.key)) continue;
                chiSquare.add(feature.key);
                values.add(new PValueKey(newChi, feature.key));
            }
        }
        int limit = WORD_LIMIT;
        if (values.size() > limit) {
            Collections.sort(values, new Comparator<PValueKey>(){

                @Override
                public int compare(PValueKey o1, PValueKey o2) {
                    int comp = Double.compare(o2.pvalue, o1.pvalue);
                    if (comp != 0) {
                        return comp;
                    }
                    return Long.compare(o1.key, o2.key);
                }
            });
            chiSquare.clear();
            int countUnigram = 0;
            int countBigram = 0;
            for (int i = 0; i < values.size(); ++i) {
                long val = ((PValueKey)values.get((int)i)).key;
                if (val > 0x100000000L && countBigram < limit) {
                    chiSquare.add(val);
                    ++countBigram;
                } else if (val < 0x100000000L && countUnigram < limit) {
                    chiSquare.add(val);
                    ++countUnigram;
                }
                if (countUnigram >= limit && countBigram >= limit) break;
            }
        }
        for (int j = 0; j < bob.length; ++j) {
            LongIntHashMap oldMap = bob[j].bob;
            bob[j].bob = new LongIntHashMap();
            for (LongIntCursor cursor : oldMap) {
                if (!chiSquare.contains(cursor.key)) continue;
                bob[j].bob.put(cursor.key, cursor.value);
            }
            oldMap.clear();
        }
        return chiSquare;
    }

    public void trainChiSquared_new(BagOfBigrams[] bob, double p_limit) {
        double label;
        LongIntHashMap featureCount = new LongIntHashMap(bob[0].bob.size());
        DoubleIntHashMap classProb = new DoubleIntHashMap(10);
        DoubleObjectHashMap<LongIntHashMap> observed = new DoubleObjectHashMap<LongIntHashMap>();
        for (BagOfBigrams bagOfPattern : bob) {
            label = bagOfPattern.label;
            int index = -1;
            LongIntHashMap obs = null;
            index = observed.indexOf(label);
            if (index > -1) {
                obs = (LongIntHashMap)observed.indexGet(index);
            } else {
                obs = new LongIntHashMap();
                observed.put(label, obs);
            }
            for (LongIntCursor word : bagOfPattern.bob) {
                if (word.value <= 0) continue;
                featureCount.putOrAdd(word.key, 1, 1);
                obs.putOrAdd(word.key, 1, 1);
            }
        }
        for (BagOfBigrams bagOfPattern : bob) {
            label = bagOfPattern.label;
            classProb.putOrAdd(label, 1, 1);
        }
        LongDoubleHashMap chiSquareSum = new LongDoubleHashMap(featureCount.size());
        for (DoubleIntCursor prob : classProb) {
            double p = (double)prob.value / (double)bob.length;
            LongIntHashMap obs = (LongIntHashMap)observed.get(prob.key);
            for (LongIntCursor feature : featureCount) {
                double expected = p * (double)feature.value;
                double chi = (double)obs.get(feature.key) - expected;
                double newChi = chi * chi / expected;
                if (!(newChi > 0.0)) continue;
                chiSquareSum.putOrAdd(feature.key, newChi, newChi);
            }
        }
        LongHashSet chiSquare = new LongHashSet(featureCount.size());
        ArrayList<PValueKey> values = new ArrayList<PValueKey>(featureCount.size());
        ChiSquaredDistribution distribution = new ChiSquaredDistribution(null, (double)(classProb.keys().size() - 1));
        for (LongDoubleCursor feature : chiSquareSum) {
            double newChi = feature.value;
            double pvalue = 1.0 - distribution.cumulativeProbability(newChi);
            if (!(pvalue <= p_limit)) continue;
            chiSquare.add(feature.key);
            values.add(new PValueKey(pvalue, feature.key));
        }
        int limit = WORD_LIMIT;
        if (values.size() > limit) {
            Collections.sort(values, new Comparator<PValueKey>(){

                @Override
                public int compare(PValueKey o1, PValueKey o2) {
                    int comp = Double.compare(o1.pvalue, o2.pvalue);
                    if (comp != 0) {
                        return comp;
                    }
                    return Long.compare(o1.key, o2.key);
                }
            });
            chiSquare.clear();
            int countUnigram = 0;
            int countBigram = 0;
            for (int i = 0; i < values.size(); ++i) {
                long val = ((PValueKey)values.get((int)i)).key;
                if (val > 0x100000000L && countBigram < limit) {
                    chiSquare.add(val);
                    ++countBigram;
                } else if (val < 0x100000000L && countUnigram < limit) {
                    chiSquare.add(val);
                    ++countUnigram;
                }
                if (countUnigram >= limit && countBigram >= limit) break;
            }
        }
        for (int j = 0; j < bob.length; ++j) {
            LongIntHashMap oldMap = bob[j].bob;
            bob[j].bob = new LongIntHashMap();
            for (LongIntCursor cursor : oldMap) {
                if (!chiSquare.contains(cursor.key)) continue;
                bob[j].bob.put(cursor.key, cursor.value);
            }
            oldMap.clear();
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        BLOCKS = runtime.availableProcessors() <= 4 ? 8 : runtime.availableProcessors();
    }

    public static class Dictionary {
        public LongIntHashMap dict = new LongIntHashMap();
        public ArrayList<Long> inverseDict = new ArrayList();

        public Dictionary() {
            this.inverseDict.add(0L);
        }

        public void reset() {
            this.dict = new LongIntHashMap();
            this.inverseDict = new ArrayList(1);
            this.inverseDict.add(0L);
        }

        public int getWordIndex(long word) {
            int index = 0;
            index = this.dict.indexOf(word);
            if (index > -1) {
                return this.dict.indexGet(index);
            }
            int newWord = this.dict.size() + 1;
            this.dict.put(word, newWord);
            this.inverseDict.add(word);
            return newWord;
        }

        public int size() {
            return this.dict.size();
        }

        public void filterChiSquared(BagOfBigrams[] bagOfPatterns) {
            for (int j = 0; j < bagOfPatterns.length; ++j) {
                LongIntHashMap oldMap = bagOfPatterns[j].bob;
                bagOfPatterns[j].bob = new LongIntHashMap();
                for (LongIntCursor word : oldMap) {
                    if (!this.dict.containsKey(word.key) || word.value <= 0) continue;
                    bagOfPatterns[j].bob.put(word.key, word.value);
                }
            }
        }
    }

    static class PValueKey {
        public double pvalue;
        public long key;

        public PValueKey(double pvalue, long key) {
            this.pvalue = pvalue;
            this.key = key;
        }

        public String toString() {
            return this.pvalue + ":" + this.key;
        }
    }

    public static class BagOfBigrams {
        public LongIntHashMap bob;
        public Double label;

        public BagOfBigrams(int size, Double label) {
            this.bob = new LongIntHashMap(size);
            this.label = label;
        }
    }
}

