/*
 * Decompiled with CFR 0.152.
 */
package sfa.transformation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import sfa.timeseries.TimeSeries;
import sfa.timeseries.TimeSeriesLoader;
import sfa.transformation.WEASEL;

@RunWith(value=JUnit4.class)
public class WEASELTest {
    @Test
    public void testCreateWordsFromVariableLengthTS() throws IOException {
        Random r = new Random(1L);
        ArrayList<TimeSeries> samples = new ArrayList<TimeSeries>();
        for (int i = 0; i < 100; ++i) {
            TimeSeries timeSeries = TimeSeriesLoader.generateRandomWalkData(1 + i, r);
            samples.add(timeSeries);
        }
        int[] windowLengths = new int[]{1024, 128, 64, 32, 4};
        WEASEL model = new WEASEL(12, 8, windowLengths, false, true);
        int[][][] words = model.createWords(samples.toArray(new TimeSeries[0]));
        for (int i = 0; i < words.length; ++i) {
            Assert.assertNotNull("Index is null: " + i, words[i]);
            for (int j = 0; j < words[i].length; ++j) {
                Assert.assertNotNull("Index is null: " + i + ":" + j, words[i][j]);
                for (int k = 0; k < words[i][j].length; ++k) {
                    Assert.assertNotNull("Index is null: " + i + ":" + j + ":" + k, words[i][j][k]);
                }
            }
        }
        WEASEL.BagOfBigrams[] bag = model.createBagOfPatterns(words, samples.toArray(new TimeSeries[0]), 8);
        Assert.assertNotNull("BagOfBigrams is null:", bag);
        TimeSeries ts = new TimeSeries(new double[0]);
        int[][][] words2 = model.createWords(new TimeSeries[]{ts});
        Assert.assertNotNull("Word is null:", words2[0]);
        WEASEL.BagOfBigrams[] bag2 = model.createBagOfPatterns(words2, new TimeSeries[]{ts}, 8);
        Assert.assertNotNull("BagOfBigrams is null:", bag2);
        System.out.println("All done");
    }

    @Test
    public void testCreateWordsFromEmptyTS() throws IOException {
        int[] windowLengths = new int[]{1024, 128, 64, 32, 4};
        WEASEL model = new WEASEL(12, 8, windowLengths, false, true);
        TimeSeries ts = new TimeSeries(new double[0]);
        int[][][] words2 = model.createWords(new TimeSeries[]{ts});
        Assert.assertNotNull("Word is null:", words2[0]);
        WEASEL.BagOfBigrams[] bag2 = model.createBagOfPatterns(words2, new TimeSeries[]{ts}, 8);
        Assert.assertNotNull("BagOfBigrams is null:", bag2);
    }
}

