/*
 * Decompiled with CFR 0.152.
 */
package com.dtw;

import com.dtw.CostMatrix;
import com.dtw.MemoryResidentMatrix;
import com.dtw.SearchWindow;
import com.dtw.SwapFileMatrix;

class WindowMatrix
implements CostMatrix {
    private CostMatrix windowCells;

    WindowMatrix(SearchWindow searchWindow) {
        try {
            this.windowCells = new MemoryResidentMatrix(searchWindow);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Ran out of memory initializing window matrix, all cells in the window cannot fit into main memory.  Will use a swap file instead (will run ~50% slower)");
            System.gc();
            this.windowCells = new SwapFileMatrix(searchWindow);
        }
    }

    @Override
    public void put(int col, int row, double value) {
        this.windowCells.put(col, row, value);
    }

    @Override
    public double get(int col, int row) {
        return this.windowCells.get(col, row);
    }

    @Override
    public int size() {
        return this.windowCells.size();
    }

    public void freeMem() {
        if (this.windowCells instanceof SwapFileMatrix) {
            try {
                ((SwapFileMatrix)this.windowCells).freeMem();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

