/*
 * Decompiled with CFR 0.152.
 */
package com.timeseries;

import com.timeseries.TimeSeries;
import com.timeseries.TimeSeriesPoint;

public class PAA
extends TimeSeries {
    private int[] aggPtSize;
    private final int originalLength;

    public PAA(TimeSeries ts, int shrunkSize) {
        if (shrunkSize > ts.size()) {
            throw new InternalError("ERROR:  The size of an aggregate representation may not be largerr than the \noriginal time series (shrunkSize=" + shrunkSize + " , origSize=" + ts.size() + ").");
        }
        if (shrunkSize <= 0) {
            throw new InternalError("ERROR:  The size of an aggregate representation must be greater than zero and \nno larger than the original time series.");
        }
        this.originalLength = ts.size();
        this.aggPtSize = new int[shrunkSize];
        super.setMaxCapacity(shrunkSize);
        this.setLabels(ts.getLabels());
        double reducedPtSize = (double)ts.size() / (double)shrunkSize;
        int ptToReadFrom = 0;
        while (ptToReadFrom < ts.size()) {
            int ptToReadTo = (int)Math.round(reducedPtSize * (double)(this.size() + 1)) - 1;
            int ptsToRead = ptToReadTo - ptToReadFrom + 1;
            double timeSum = 0.0;
            double[] measurementSums = new double[ts.numOfDimensions()];
            for (int pt = ptToReadFrom; pt <= ptToReadTo; ++pt) {
                double[] currentPoint = ts.getMeasurementVector(pt);
                timeSum += ts.getTimeAtNthPoint(pt);
                for (int dim = 0; dim < ts.numOfDimensions(); ++dim) {
                    int n = dim;
                    measurementSums[n] = measurementSums[n] + currentPoint[dim];
                }
            }
            timeSum /= (double)ptsToRead;
            for (int dim = 0; dim < ts.numOfDimensions(); ++dim) {
                measurementSums[dim] = measurementSums[dim] / (double)ptsToRead;
            }
            this.aggPtSize[super.size()] = ptsToRead;
            this.addLast(timeSum, new TimeSeriesPoint(measurementSums));
            ptToReadFrom = ptToReadTo + 1;
        }
    }

    public int originalSize() {
        return this.originalLength;
    }

    public int aggregatePtSize(int ptIndex) {
        return this.aggPtSize[ptIndex];
    }

    @Override
    public String toString() {
        return "(" + this.originalLength + " point time series represented as " + this.size() + " points)\n" + super.toString();
    }
}

