/*
 * Decompiled with CFR 0.152.
 */
package com.timeseries;

import com.timeseries.TimeSeriesPoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeSeries {
    private static final int[] ZERO_ARRAY = new int[0];
    private static final boolean DEFAULT_IS_TIME_1ST_COL = true;
    private static final char DEFAULT_DELIMITER = ',';
    private static final boolean DEFAULT_IS_LABELED = true;
    private final ArrayList labels;
    private final ArrayList timeReadings;
    private final ArrayList tsArray;

    public TimeSeries(double[] x) {
        AtomicInteger counter = new AtomicInteger();
        this.timeReadings = new ArrayList();
        this.labels = new ArrayList();
        this.labels.add("Time");
        this.labels.add("c1");
        this.tsArray = new ArrayList();
        for (double value : x) {
            this.timeReadings.add(Double.valueOf(counter.getAndIncrement()));
            ArrayList<Double> values = new ArrayList<Double>();
            values.add(value);
            TimeSeriesPoint tsValues = new TimeSeriesPoint(values);
            this.tsArray.add(tsValues);
        }
    }

    TimeSeries() {
        this.labels = new ArrayList();
        this.timeReadings = new ArrayList();
        this.tsArray = new ArrayList();
    }

    public TimeSeries(int numOfDimensions) {
        this();
        this.labels.add("Time");
        for (int x = 0; x < numOfDimensions; ++x) {
            this.labels.add("" + x);
        }
    }

    public TimeSeries(TimeSeries origTS) {
        this.labels = new ArrayList(origTS.labels);
        this.timeReadings = new ArrayList(origTS.timeReadings);
        this.tsArray = new ArrayList(origTS.tsArray);
    }

    public TimeSeries(String inputFile, boolean isFirstColTime) {
        this(inputFile, ZERO_ARRAY, isFirstColTime);
    }

    public TimeSeries(String inputFile, char delimiter) {
        this(inputFile, ZERO_ARRAY, true, true, delimiter);
    }

    public TimeSeries(String inputFile, boolean isFirstColTime, char delimiter) {
        this(inputFile, ZERO_ARRAY, isFirstColTime, true, delimiter);
    }

    public TimeSeries(String inputFile, boolean isFirstColTime, boolean isLabeled, char delimiter) {
        this(inputFile, ZERO_ARRAY, isFirstColTime, isLabeled, delimiter);
    }

    public TimeSeries(String inputFile, int[] colToInclude, boolean isFirstColTime) {
        this(inputFile, colToInclude, isFirstColTime, true, ',');
    }

    public TimeSeries(String inputFile, int[] colToInclude, boolean isFirstColTime, boolean isLabeled, char delimiter) {
        this();
        try {
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line, String.valueOf(delimiter));
            if (isLabeled) {
                int currentCol = 0;
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken();
                    if (colToInclude.length == 0 || com.util.Arrays.contains(colToInclude, currentCol)) {
                        this.labels.add(currentToken);
                    }
                    ++currentCol;
                }
                if (this.labels.size() == 0) {
                    throw new InternalError("ERROR:  The first row must contain label information, it is empty!");
                }
                if (!isFirstColTime) {
                    this.labels.add(0, "Time");
                } else if (isFirstColTime && !((String)this.labels.get(0)).equalsIgnoreCase("Time")) {
                    throw new InternalError("ERROR:  The time column (1st col) in a time series must be labeled as 'Time', '" + this.labels.get(0) + "' was found instead");
                }
            } else {
                if (colToInclude == null || colToInclude.length == 0) {
                    this.labels.add("Time");
                    if (isFirstColTime) {
                        st.nextToken();
                    }
                    int currentCol = 1;
                    while (st.hasMoreTokens()) {
                        st.nextToken();
                        this.labels.add(new String("c" + currentCol++));
                    }
                } else {
                    Arrays.sort(colToInclude);
                    this.labels.add("Time");
                    for (int c = 0; c < colToInclude.length; ++c) {
                        if (colToInclude[c] <= 0) continue;
                        this.labels.add(new String("c" + c));
                    }
                }
                br.close();
                br = new BufferedReader(new FileReader(inputFile));
            }
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                st = new StringTokenizer(line, ",");
                ArrayList<Double> currentLineValues = new ArrayList<Double>();
                int currentCol = 0;
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken();
                    if (colToInclude.length == 0 || com.util.Arrays.contains(colToInclude, currentCol)) {
                        Double nextValue;
                        try {
                            nextValue = Double.valueOf(currentToken);
                        }
                        catch (NumberFormatException e) {
                            throw new InternalError("ERROR:  '" + currentToken + "' is not a valid number");
                        }
                        currentLineValues.add(nextValue);
                    }
                    ++currentCol;
                }
                if (isFirstColTime) {
                    this.timeReadings.add(currentLineValues.get(0));
                } else {
                    this.timeReadings.add(new Double(this.timeReadings.size()));
                }
                int firstMeasurement = isFirstColTime ? 1 : 0;
                TimeSeriesPoint readings = new TimeSeriesPoint(currentLineValues.subList(firstMeasurement, currentLineValues.size()));
                this.tsArray.add(readings);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            throw new InternalError("ERROR:  The file '" + inputFile + "' was not found.");
        }
        catch (IOException e) {
            throw new InternalError("ERROR:  Problem reading the file '" + inputFile + "'.");
        }
    }

    public void save(File outFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
        out.write(this.toString());
        out.flush();
        out.close();
    }

    public void clear() {
        this.labels.clear();
        this.timeReadings.clear();
        this.tsArray.clear();
    }

    public int size() {
        return this.timeReadings.size();
    }

    public int numOfPts() {
        return this.size();
    }

    public int numOfDimensions() {
        return this.labels.size() - 1;
    }

    public double getTimeAtNthPoint(int n) {
        return (Double)this.timeReadings.get(n);
    }

    public String getLabel(int index) {
        return (String)this.labels.get(index);
    }

    public String[] getLabelsArr() {
        String[] labelArr = new String[this.labels.size()];
        for (int x = 0; x < this.labels.size(); ++x) {
            labelArr[x] = (String)this.labels.get(x);
        }
        return labelArr;
    }

    public ArrayList getLabels() {
        return this.labels;
    }

    public void setLabels(String[] newLabels) {
        this.labels.clear();
        for (int x = 0; x < newLabels.length; ++x) {
            this.labels.add(newLabels[x]);
        }
    }

    public void setLabels(ArrayList newLabels) {
        this.labels.clear();
        for (int x = 0; x < newLabels.size(); ++x) {
            this.labels.add(newLabels.get(x));
        }
    }

    public double getMeasurement(int pointIndex, int valueIndex) {
        return ((TimeSeriesPoint)this.tsArray.get(pointIndex)).get(valueIndex);
    }

    public double getMeasurement(int pointIndex, String valueLabel) {
        int valueIndex = this.labels.indexOf(valueLabel);
        if (valueIndex < 0) {
            throw new InternalError("ERROR:  the label '" + valueLabel + "' was not one of:  " + this.labels);
        }
        return ((TimeSeriesPoint)this.tsArray.get(pointIndex)).get(valueIndex - 1);
    }

    public double[] getMeasurementVector(int pointIndex) {
        return ((TimeSeriesPoint)this.tsArray.get(pointIndex)).toArray();
    }

    public void setMeasurement(int pointIndex, int valueIndex, double newValue) {
        ((TimeSeriesPoint)this.tsArray.get(pointIndex)).set(valueIndex, newValue);
    }

    public void addFirst(double time, TimeSeriesPoint values) {
        if (this.labels.size() != values.size() + 1) {
            throw new InternalError("ERROR:  The TimeSeriesPoint: " + values + " contains the wrong number of values. expected:  " + this.labels.size() + ", found: " + values.size());
        }
        if (time >= (Double)this.timeReadings.get(0)) {
            throw new InternalError("ERROR:  The point being inserted into the beginning of the time series does not have the correct time sequence. ");
        }
        this.timeReadings.add(0, new Double(time));
        this.tsArray.add(0, values);
    }

    public void addLast(double time, TimeSeriesPoint values) {
        if (this.labels.size() != values.size() + 1) {
            throw new InternalError("ERROR:  The TimeSeriesPoint: " + values + " contains the wrong number of values. expected:  " + this.labels.size() + ", found: " + values.size());
        }
        if (this.size() > 0 && time <= (Double)this.timeReadings.get(this.timeReadings.size() - 1)) {
            throw new InternalError("ERROR:  The point being inserted at the end of the time series does not have the correct time sequence. ");
        }
        this.timeReadings.add(new Double(time));
        this.tsArray.add(values);
    }

    public void removeFirst() {
        if (this.size() == 0) {
            System.err.println("WARNING:  TimeSeriesPoint:removeFirst() called on an empty time series!");
        } else {
            this.timeReadings.remove(0);
            this.tsArray.remove(0);
        }
    }

    public void removeLast() {
        if (this.size() == 0) {
            System.err.println("WARNING:  TimeSeriesPoint:removeLast() called on an empty time series!");
        } else {
            this.tsArray.remove(this.timeReadings.size() - 1);
            this.timeReadings.remove(this.timeReadings.size() - 1);
        }
    }

    public void normalize() {
        double[] mean = new double[this.numOfDimensions()];
        for (int col = 0; col < this.numOfDimensions(); ++col) {
            double currentSum = 0.0;
            for (int row = 0; row < this.size(); ++row) {
                currentSum += this.getMeasurement(row, col);
            }
            mean[col] = currentSum / (double)this.size();
        }
        double[] stdDev = new double[this.numOfDimensions()];
        for (int col = 0; col < this.numOfDimensions(); ++col) {
            double variance = 0.0;
            for (int row = 0; row < this.size(); ++row) {
                variance += Math.abs(this.getMeasurement(row, col) - mean[col]);
            }
            stdDev[col] = variance / (double)this.size();
        }
        for (int row = 0; row < this.size(); ++row) {
            for (int col = 0; col < this.numOfDimensions(); ++col) {
                if (stdDev[col] == 0.0) {
                    this.setMeasurement(row, col, 0.0);
                    continue;
                }
                this.setMeasurement(row, col, (this.getMeasurement(row, col) - mean[col]) / stdDev[col]);
            }
        }
    }

    public String toString() {
        StringBuffer outStr = new StringBuffer();
        for (int r = 0; r < this.timeReadings.size(); ++r) {
            TimeSeriesPoint values = (TimeSeriesPoint)this.tsArray.get(r);
            for (int c = 0; c < values.size(); ++c) {
                outStr.append(values.get(c));
            }
            if (r >= this.timeReadings.size() - 1) continue;
            outStr.append("\n");
        }
        return outStr.toString();
    }

    private static char determineDelimiter(String filePath) {
        int DEFAULT_DELIMITER = 44;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            String line = in.readLine().trim();
            if (!Character.isDigit(line.charAt(0))) {
                line = in.readLine();
            }
            in.close();
            for (int x = 0; x < line.length(); ++x) {
                if (Character.isDigit(line.charAt(x)) || line.charAt(x) == '.' || line.charAt(x) == '-' || Character.toUpperCase(line.charAt(x)) == 'E') continue;
                return line.charAt(x);
            }
            return ',';
        }
        catch (IOException e) {
            return ',';
        }
    }

    private static double extractFirstNumber(String str) {
        StringBuffer numStr = new StringBuffer();
        for (int x = 0; x < str.length(); ++x) {
            if (Character.isDigit(str.charAt(x)) || str.charAt(x) == '.' || str.charAt(x) == '-' || Character.toUpperCase(str.charAt(x)) == 'E') {
                numStr.append(str.charAt(x));
                continue;
            }
            Double.parseDouble(numStr.toString());
        }
        return -1.0;
    }

    private static boolean determineIsFirstColTime(String filePath) {
        boolean DEFAULT_VALUE = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            double EQUALITY_FLEXIBILITY_PCT = 0.001;
            int NUM_OF_VALUES_TO_CMP = 100;
            Vector<Double> possibleTimeValues = new Vector<Double>(100);
            String line = in.readLine();
            while (possibleTimeValues.size() < 100 && (line = in.readLine()) != null) {
                possibleTimeValues.add(new Double(TimeSeries.extractFirstNumber(line)));
            }
            if (possibleTimeValues.size() <= 1) {
                return false;
            }
            if (possibleTimeValues.size() > 1 && possibleTimeValues.get(1).equals(possibleTimeValues.get(0))) {
                return false;
            }
            double expectedDiff = (Double)possibleTimeValues.get(1) - (Double)possibleTimeValues.get(0);
            double flexibility = expectedDiff * 0.001;
            for (int x = 1; x < possibleTimeValues.size(); ++x) {
                if (!(Math.abs((Double)possibleTimeValues.get(x) - (Double)possibleTimeValues.get(x - 1) - expectedDiff) > Math.abs(flexibility))) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void setMaxCapacity(int capacity) {
        this.timeReadings.ensureCapacity(capacity);
        this.tsArray.ensureCapacity(capacity);
    }
}

