/*
 * Decompiled with CFR 0.152.
 */
package com.timeseries;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class TimeSeriesPoint {
    private double[] measurements;
    private int hashCode;

    public TimeSeriesPoint(double[] values) {
        this.hashCode = 0;
        this.measurements = new double[values.length];
        for (int x = 0; x < values.length; ++x) {
            this.hashCode += new Double(values[x]).hashCode();
            this.measurements[x] = values[x];
        }
    }

    public TimeSeriesPoint(Collection values) {
        this.measurements = new double[values.size()];
        this.hashCode = 0;
        Iterator i = values.iterator();
        int index = 0;
        while (i.hasNext()) {
            Object nextElement = i.next();
            if (nextElement instanceof Double) {
                this.measurements[index] = (Double)nextElement;
            } else if (nextElement instanceof Integer) {
                this.measurements[index] = ((Integer)nextElement).doubleValue();
            } else if (nextElement instanceof BigInteger) {
                this.measurements[index] = ((BigInteger)nextElement).doubleValue();
            } else {
                throw new InternalError("ERROR:  The element " + nextElement + " is not a valid numeric type");
            }
            this.hashCode += new Double(this.measurements[index]).hashCode();
            ++index;
        }
    }

    public double get(int dimension) {
        return this.measurements[dimension];
    }

    public void set(int dimension, double newValue) {
        this.hashCode -= new Double(this.measurements[dimension]).hashCode();
        this.measurements[dimension] = newValue;
        this.hashCode += new Double(newValue).hashCode();
    }

    public double[] toArray() {
        return this.measurements;
    }

    public int size() {
        return this.measurements.length;
    }

    public String toString() {
        Object outStr = "(";
        for (int x = 0; x < this.measurements.length; ++x) {
            outStr = (String)outStr + this.measurements[x];
            if (x >= this.measurements.length - 1) continue;
            outStr = (String)outStr + ",";
        }
        outStr = (String)outStr + ")";
        return outStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TimeSeriesPoint) {
            double[] testValues = ((TimeSeriesPoint)o).toArray();
            if (testValues.length == this.measurements.length) {
                for (int x = 0; x < this.measurements.length; ++x) {
                    if (this.measurements[x] == testValues[x]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

