/*
 * Decompiled with CFR 0.152.
 */
package edu.ucr.benchmark;

import com.dtw.FastDTW;
import com.timeseries.TimeSeries;
import edu.ucr.impl.DtwUpd;
import edu.ucr.util.ProgressBar;
import edu.ucr.util.SquaredDistance;
import edu.ucr.util.TsvReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class WarpWindowPairwiseBenchmark {
    private static final int MEASURE_ROUNDS = 10;

    public static void main(String[] args) throws IOException {
        ArrayList<Integer> label = new ArrayList<Integer>();
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<TimeSeries> dataTS = new ArrayList<TimeSeries>();
        int dtwMethod = Integer.parseInt(args[1]);
        int start = Integer.parseInt(args[2]);
        int end = Integer.parseInt(args[3]);
        int step = Integer.parseInt(args[4]);
        TsvReader.readTsv(args[0], data, dataTS, label);
        System.out.format("DTW method: %d (0: FastDTW, 1: cDTW)\n", dtwMethod);
        try (PrintWriter outputWriter = new PrintWriter(args[5]);){
            int i;
            outputWriter.print("warpWindowSize");
            for (i = 0; i < 10; ++i) {
                outputWriter.print(",time" + (i + 1));
            }
            outputWriter.print(",averageTime");
            outputWriter.println();
            for (i = start; i <= end; i += step) {
                int warpWindowSize = (int)Math.ceil((double)(data.get(0).length * i) / 100.0);
                if (dtwMethod == 0) {
                    warpWindowSize = i;
                }
                System.out.println("-----------------------------------------------");
                System.out.format("Warp window size: %d", warpWindowSize);
                if (dtwMethod == 1) {
                    System.out.format(" (%d%%)", i);
                }
                System.out.println();
                outputWriter.print(warpWindowSize);
                long totalElapsed = 0L;
                int actualMeasureRounds = 0;
                int profiledMeasureRound = 10;
                int k = 0;
                while (k < 10 && k < profiledMeasureRound) {
                    long roundElapsed = 0L;
                    int pairsDone = 0;
                    for (int l = 0; l < label.size(); ++l) {
                        for (int m = l + 1; m < label.size(); ++m) {
                            long elapsed;
                            switch (dtwMethod) {
                                default: {
                                    long startTime = System.nanoTime();
                                    FastDTW.getWarpDistBetween(dataTS.get(l), dataTS.get(m), warpWindowSize, new SquaredDistance());
                                    elapsed = System.nanoTime() - startTime;
                                    break;
                                }
                                case 1: {
                                    long startTime = System.nanoTime();
                                    DtwUpd.computeDtw(data.get(l), data.get(m), warpWindowSize);
                                    elapsed = System.nanoTime() - startTime;
                                }
                            }
                            roundElapsed += elapsed;
                            ProgressBar.show(k + 1, ++pairsDone, label.size() * (label.size() - 1) / 2);
                        }
                    }
                    System.out.format(", time elapsed: %.6fs\n", (double)roundElapsed * 1.0 / 1.0E9);
                    outputWriter.format(",%.6f", (double)roundElapsed * 1.0 / 1.0E9);
                    double currentAverage = (double)(totalElapsed += roundElapsed) * 1.0 / (double)actualMeasureRounds / 1.0E9;
                    profiledMeasureRound = currentAverage < 3600.0 ? Math.max(3, (int)Math.ceil(3600.0 / currentAverage)) : 2;
                    ++k;
                    ++actualMeasureRounds;
                }
                for (k = actualMeasureRounds; k < 10; ++k) {
                    outputWriter.write(",N/A");
                }
                System.out.format("Average time: %.6fs\n", (double)totalElapsed * 1.0 / (double)actualMeasureRounds / 1.0E9);
                outputWriter.format(",%.6f\n", (double)totalElapsed * 1.0 / (double)actualMeasureRounds / 1.0E9);
                outputWriter.flush();
            }
        }
    }
}

