/*
 * Decompiled with CFR 0.152.
 */
package edu.ucr.impl;

public class DtwUpd {
    public static double computeDtw(double[] A, double[] B, int radius) {
        int k;
        int m = A.length;
        int r = radius;
        double[] cost = new double[2 * r + 1];
        double[] costPrev = new double[2 * r + 1];
        for (k = 0; k < 2 * r + 1; ++k) {
            cost[k] = Double.POSITIVE_INFINITY;
            costPrev[k] = Double.POSITIVE_INFINITY;
        }
        for (int i = 0; i < m; ++i) {
            k = Integer.max(0, r - i);
            int j = Integer.max(0, i - r);
            while (j <= Integer.min(m - 1, i + r)) {
                if (i == 0 && j == 0) {
                    double c = A[0] - B[0];
                    cost[k] = c * c;
                } else {
                    double y = j - 1 < 0 || k - 1 < 0 ? Double.POSITIVE_INFINITY : cost[k - 1];
                    double x = i < 1 || k > 2 * r - 1 ? Double.POSITIVE_INFINITY : costPrev[k + 1];
                    double z = i < 1 || j < 1 ? Double.POSITIVE_INFINITY : costPrev[k];
                    double d = A[i] - B[j];
                    cost[k] = Double.min(Double.min(x, y), z) + d * d;
                }
                ++j;
                ++k;
            }
            double[] tmp = cost;
            cost = costPrev;
            costPrev = tmp;
        }
        return costPrev[--k];
    }
}

