/*
 * Decompiled with CFR 0.152.
 */
package edu.ucr.runner;

import com.dtw.FastDTW;
import com.timeseries.TimeSeries;
import edu.ucr.impl.DtwUpd;
import edu.ucr.util.ProgressBar;
import edu.ucr.util.SquaredDistance;
import edu.ucr.util.TsvReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PairsRunner {
    private static final int MEASURE_ROUNDS = 1000;
    private static final int[] FASTDTW_RADIUS = new int[]{10, 20, 30, 40};

    public static void main(String[] args) throws IOException {
        ArrayList<Integer> labelA = new ArrayList<Integer>();
        ArrayList<double[]> dataA = new ArrayList<double[]>();
        ArrayList<TimeSeries> dataATS = new ArrayList<TimeSeries>();
        ArrayList<Integer> labelB = new ArrayList<Integer>();
        ArrayList<double[]> dataB = new ArrayList<double[]>();
        ArrayList<TimeSeries> dataBTS = new ArrayList<TimeSeries>();
        TsvReader.readTsv(args[0], dataA, dataATS, labelA);
        TsvReader.readTsv(args[1], dataB, dataBTS, labelB);
        double cDtwPercent = Double.parseDouble(args[2]);
        try (PrintWriter outputWriter = new PrintWriter(args[3]);){
            outputWriter.print("Label");
            for (int radius : FASTDTW_RADIUS) {
                outputWriter.format(",FastDTW%dDist", radius);
            }
            outputWriter.print(",cDTWDist");
            for (int radius : FASTDTW_RADIUS) {
                outputWriter.format(",FastDtw%dTime", radius);
            }
            outputWriter.println(",cDTWTime");
            for (int i = 0; i < labelA.size(); ++i) {
                int k;
                long[] fastDtwTotal = new long[FASTDTW_RADIUS.length];
                long cDtwTotal = 0L;
                double[] fastDtwDist = new double[FASTDTW_RADIUS.length];
                double cDtwDist = -1.0;
                for (int j = 0; j < 1000; ++j) {
                    long elapsed;
                    int k2 = 0;
                    while (k2 < FASTDTW_RADIUS.length) {
                        long startTime = System.nanoTime();
                        fastDtwDist[k2] = FastDTW.getWarpDistBetween(dataATS.get(i), dataBTS.get(i), FASTDTW_RADIUS[k2], new SquaredDistance());
                        elapsed = System.nanoTime() - startTime;
                        int n = k2++;
                        fastDtwTotal[n] = fastDtwTotal[n] + elapsed;
                    }
                    long startTime = System.nanoTime();
                    cDtwDist = DtwUpd.computeDtw(dataA.get(i), dataB.get(i), (int)Math.ceil((double)dataA.get(i).length * cDtwPercent / 100.0));
                    elapsed = System.nanoTime() - startTime;
                    cDtwTotal += elapsed;
                    ProgressBar.show(i + 1, j + 1, 1000);
                }
                outputWriter.format("%d", labelA.get(i));
                for (k = 0; k < FASTDTW_RADIUS.length; ++k) {
                    outputWriter.format(",%.6f", fastDtwDist[k]);
                }
                outputWriter.format(",%.6f", cDtwDist);
                for (k = 0; k < FASTDTW_RADIUS.length; ++k) {
                    double avg = (double)fastDtwTotal[k] * 1.0 / 1000.0;
                    outputWriter.format(",%.6f", avg);
                }
                double cDtwAvg = (double)cDtwTotal * 1.0 / 1000.0;
                outputWriter.format(",%.6f", cDtwAvg);
                outputWriter.println();
                outputWriter.flush();
                for (int k3 = 0; k3 < FASTDTW_RADIUS.length; ++k3) {
                    double avg = (double)fastDtwTotal[k3] * 1.0 / 1000.0;
                    System.out.format(", fastDTW%d avg.: %.6f ns", FASTDTW_RADIUS[k3], avg);
                }
                System.out.format(", cDTW avg.: %.6f ns\n", cDtwAvg);
            }
        }
    }
}

