/*
 * Decompiled with CFR 0.152.
 */
package edu.ucr.runner;

import com.dtw.FastDTW;
import com.timeseries.TimeSeries;
import edu.ucr.impl.DtwUpd;
import edu.ucr.util.SquaredDistance;
import edu.ucr.util.TsvReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PairwiseRunner {
    private static final int[] FASTDTW_RADIUS = new int[]{10, 20, 30, 40};

    public static void main(String[] args) throws IOException {
        ArrayList<Integer> label = new ArrayList<Integer>();
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<TimeSeries> dataTS = new ArrayList<TimeSeries>();
        TsvReader.readTsv(args[0], data, dataTS, label);
        try (PrintWriter outputWriter = new PrintWriter(args[1]);){
            outputWriter.print("timeSeries1,timeSeries2");
            for (int radius : FASTDTW_RADIUS) {
                outputWriter.format(",FastDTW%dDist", radius);
            }
            outputWriter.print(",fullDTWDist");
            outputWriter.println();
            for (int i = 0; i < label.size(); ++i) {
                for (int j = i + 1; j < label.size(); ++j) {
                    outputWriter.format("%d,%d", label.get(i), label.get(j));
                    for (int radius : FASTDTW_RADIUS) {
                        double fastDtw = FastDTW.getWarpDistBetween(dataTS.get(i), dataTS.get(j), radius, new SquaredDistance());
                        outputWriter.format(",%.6f", fastDtw);
                    }
                    double cDtw = DtwUpd.computeDtw(data.get(i), data.get(j), data.get(i).length);
                    outputWriter.format(",%.6f", cDtw);
                    outputWriter.println();
                    outputWriter.flush();
                }
            }
        }
    }
}

