/*
 * Decompiled with CFR 0.152.
 */
package com.dtw;

import com.dtw.DTW;
import com.dtw.ExpandedResWindow;
import com.dtw.TimeWarpInfo;
import com.dtw.WarpPath;
import com.timeseries.PAA;
import com.timeseries.TimeSeries;
import com.util.DistanceFunction;

public class FastDTW {
    static final int DEFAULT_SEARCH_RADIUS = 1;

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, 1, distFn).getDistance();
    }

    public static double getWarpDistBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn).getDistance();
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, 1, distFn).getPath();
    }

    public static WarpPath getWarpPathBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries tsI, TimeSeries tsJ, int searchRadius, DistanceFunction distFn) {
        return FastDTW.fastDTW(tsI, tsJ, searchRadius, distFn);
    }

    private static TimeWarpInfo fastDTW(TimeSeries tsI, TimeSeries tsJ, int searchRadius, DistanceFunction distFn) {
        if (searchRadius < 0) {
            searchRadius = 0;
        }
        int minTSsize = searchRadius + 2;
        if (tsI.size() <= minTSsize || tsJ.size() <= minTSsize) {
            return DTW.getWarpInfoBetween(tsI, tsJ, distFn);
        }
        double resolutionFactor = 2.0;
        PAA shrunkI = new PAA(tsI, (int)((double)tsI.size() / 2.0));
        PAA shrunkJ = new PAA(tsJ, (int)((double)tsJ.size() / 2.0));
        ExpandedResWindow window = new ExpandedResWindow(tsI, tsJ, shrunkI, shrunkJ, FastDTW.getWarpPathBetween(shrunkI, shrunkJ, searchRadius, distFn), searchRadius);
        return DTW.getWarpInfoBetween(tsI, tsJ, window, distFn);
    }
}

